/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.querytemplates;

import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import org.apache.velocity.VelocityContext;

public abstract class MemberQuery
extends CustomQuery {
    private static final String DIMENSION_PROPERTIES = "DIMENSION_PROPERTIES";
    private static final String SAP_VARIABLES = "SAP_VARIABLES";
    private static final String NON_EMPTY_STRING = "NON EMPTY";
    private static final String NON_EMPTY = "NON_EMPTY";
    private static final String MDX_OPEN_BRACKET = "[";
    private static final String MDX_CLOSE_BRACKET = "]";
    private String variables;
    private String keyDate;
    private String dimensionProperties;
    protected boolean nonEmpty = true;
    private String measureHierName;

    protected MemberQuery(ICube aCube) {
        super(aCube);
    }

    @Override
    protected VelocityContext constructContext() {
        VelocityContext context = new VelocityContext();
        if (this.dimensionProperties == null) {
            context.put(DIMENSION_PROPERTIES, (Object)"");
        } else {
            context.put(DIMENSION_PROPERTIES, (Object)this.dimensionProperties);
        }
        if (this.variables == null) {
            context.put(SAP_VARIABLES, (Object)"");
        } else {
            context.put(SAP_VARIABLES, (Object)this.variables);
        }
        if (this.nonEmpty) {
            context.put(NON_EMPTY, (Object)NON_EMPTY_STRING);
        } else {
            context.put(NON_EMPTY, (Object)"");
        }
        String cubeName = this.getReferencedCube().getName();
        if (!cubeName.startsWith(MDX_OPEN_BRACKET)) {
            StringBuilder sb = new StringBuilder(MDX_OPEN_BRACKET);
            sb.append(cubeName);
            sb.append(MDX_CLOSE_BRACKET);
            cubeName = sb.toString();
        }
        context.put("CUBE_NAME", (Object)cubeName);
        context.put("MEASURE_HIERARCHY_NAME", (Object)this.measureHierName);
        return context;
    }

    public void setDimensionProperties(String theDimensionProperties) {
        this.dimensionProperties = theDimensionProperties;
    }

    public void setNonEmpty(boolean theNonEmpty) {
        this.nonEmpty = theNonEmpty;
    }

    public void setVariables(String theVariables) {
        this.variables = theVariables;
    }

    public void setMeasuresHierarchy(String measures) {
        this.measureHierName = measures;
    }

    public void setKeyDate(String theKeyDate) {
        this.keyDate = theKeyDate;
    }

    public String getKeyDate() {
        return this.keyDate;
    }

    @Override
    public boolean isCustomMemberQuery() {
        return true;
    }
}

