/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.querytemplates;

import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import org.apache.velocity.VelocityContext;
import org.dom4j.Element;

public class MissingMemberValidateQuery
extends CustomQuery {
    private static final String CUBE_NAME = "CUBE_NAME";
    private static final String MEMBER_NAME = "MEMBER_NAME";
    private static final String MEASURE_HIERARCHY_NAME = "MEASURE_HIERARCHY_NAME";
    public static final String TYPE_NAME = "MissingMemberValidateQuery";
    private static final String TEMPLATE_PATH = "com/cognos/xqe/runtree/olap/querytemplates/MissingMemberValidateQuery";
    private String memberName;

    protected MissingMemberValidateQuery(ICube aCube) {
        super(aCube);
        this.setEscapeParameters(true);
    }

    public void setMemberName(String aName) {
        this.memberName = aName;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.memberName = inputNode.attributeValue("targetName");
    }

    @Override
    protected String getTemplateName() {
        return TEMPLATE_PATH;
    }

    @Override
    protected VelocityContext constructContext() {
        VelocityContext context = new VelocityContext();
        String measureHierName = this.getReferencedCube().getMeasuresHierarchy().getUniqueName();
        String cubeName = this.getReferencedCube().getName();
        if (this.getDataSourceType().equals("PC") || this.getDataSourceType().equals("TM")) {
            measureHierName = XMLEscCharacter.escapeString(measureHierName);
            measureHierName = MissingMemberValidateQuery.escapeSquareBrackets(measureHierName);
            cubeName = XMLEscCharacter.escapeString(cubeName);
            if (this.isEscapeParameters()) {
                this.memberName = XMLEscCharacter.escapeString(this.memberName);
                this.memberName = MissingMemberValidateQuery.escapeSquareBrackets(this.memberName);
            }
        }
        context.put(MEASURE_HIERARCHY_NAME, (Object)measureHierName);
        context.put(MEMBER_NAME, (Object)this.memberName);
        context.put(CUBE_NAME, (Object)cubeName);
        return context;
    }

    public static String escapeSquareBrackets(String multiPartName) {
        String[] parts = UniqueNameParser.parseNoThrow(multiPartName);
        if (parts != null && parts.length > 1) {
            String[] newParts = new String[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                newParts[i] = UniqueNameParser.escapeSquareBrackets(parts[i]);
            }
            multiPartName = UniqueNameGenerator.createUniqueName(newParts);
        }
        return multiPartName;
    }
}

