/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class XCrossJoin
extends XJoin {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public XCrossJoin() {
        super.setJoinType(XJoin.JoinType.CROSS);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XCrossJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501006;
    }

    @Override
    public IXQEQueryNode getPredicate() {
        return null;
    }

    private final class XCrossJoinResultSet
    extends XJoin.ResultSet
    implements ITabularResultSet {
        private int nChildren;
        private ITabularIterator[] tabIt;
        private IRow[] rowList;
        private int current;

        XCrossJoinResultSet(XDataContext context) {
            super(context, XCrossJoin.this.getId());
            this.current = 0;
            this.nChildren = XCrossJoin.this.getNumberChildren();
            try {
                int i;
                this.iResultSets = new IHybridResultSet[this.nChildren];
                this.iRowsetInfo = new IRowsetInfo[this.nChildren];
                this.tabIt = new XTabularIterator[this.nChildren];
                this.rowList = new IRow[this.nChildren];
                for (i = 0; i < this.nChildren; ++i) {
                    IHybridResultSet resultSet = (IHybridResultSet)((IExecutable)((Object)XCrossJoin.this.getChild(i))).execute(context);
                    this.iRowsetInfo[i] = resultSet.getTabularRowsetInfo();
                    this.iResultSets[i] = resultSet;
                    if (!XCrossJoin.this.isLateralJoin() || i >= this.nChildren - 1) continue;
                    this.tabIt[i] = resultSet.getTabularIterator();
                    IRow row = (IRow)this.tabIt[i].next();
                    if (row == null) continue;
                    this.rowList[i] = row;
                    ++this.current;
                }
                this.rowsetInfo = new RowsetInfo();
                for (i = 0; i < this.iResultSets.length; ++i) {
                    this.rowsetInfo.add(this.iRowsetInfo[i]);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XCrossJoinIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.tabIt != null) {
                for (int i = 0; i < this.tabIt.length; ++i) {
                    try {
                        if (this.tabIt[i] == null) continue;
                        this.tabIt[i].release();
                        continue;
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                        continue;
                    }
                    finally {
                        this.tabIt[i] = null;
                    }
                }
                this.tabIt = null;
            }
            super.releaseImpl();
        }

        static /* synthetic */ ITabularIterator[] access$402(XCrossJoinResultSet x0, ITabularIterator[] x1) {
            x0.tabIt = x1;
            return x1;
        }

        static /* synthetic */ IRow[] access$602(XCrossJoinResultSet x0, IRow[] x1) {
            x0.rowList = x1;
            return x1;
        }

        private final class XCrossJoinIterator
        extends XTabularIterator {
            private IRow result;

            private XCrossJoinIterator(XDataContext context) {
                super(context, XCrossJoin.this.getId());
                try {
                    this.startTimer();
                    this.result = DataValueFactory.createRowValue(XCrossJoinResultSet.this.rowsetInfo);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                while (XCrossJoinResultSet.this.current >= 0) {
                    IRow inputRow;
                    if (XCrossJoinResultSet.this.iResultSets[XCrossJoinResultSet.this.current] == null) {
                        XCrossJoinResultSet.this.iResultSets[((XCrossJoinResultSet)XCrossJoinResultSet.this).current] = (IHybridResultSet)((IExecutable)((Object)XCrossJoin.this.getChild(XCrossJoinResultSet.this.current))).execute(this.context);
                    }
                    if (XCrossJoinResultSet.this.tabIt[XCrossJoinResultSet.this.current] == null) {
                        ((XCrossJoinResultSet)XCrossJoinResultSet.this).tabIt[((XCrossJoinResultSet)XCrossJoinResultSet.this).current] = XCrossJoinResultSet.this.iResultSets[XCrossJoinResultSet.this.current].getTabularIterator();
                    }
                    if ((inputRow = (IRow)XCrossJoinResultSet.this.tabIt[XCrossJoinResultSet.this.current].next()) == null) {
                        if (XCrossJoin.this.isLateralJoin() && XCrossJoinResultSet.this.current == XCrossJoinResultSet.this.nChildren - 1) {
                            XCrossJoinResultSet.this.tabIt[XCrossJoinResultSet.this.current].release();
                            ((XCrossJoinResultSet)XCrossJoinResultSet.this).tabIt[((XCrossJoinResultSet)XCrossJoinResultSet.this).current] = null;
                            XCrossJoinResultSet.this.iResultSets[XCrossJoinResultSet.this.current].release();
                            XCrossJoinResultSet.this.iResultSets[((XCrossJoinResultSet)XCrossJoinResultSet.this).current] = null;
                        }
                        --XCrossJoinResultSet.this.current;
                        continue;
                    }
                    ((XCrossJoinResultSet)XCrossJoinResultSet.this).rowList[((XCrossJoinResultSet)XCrossJoinResultSet.this).current] = inputRow;
                    if (XCrossJoinResultSet.this.current == XCrossJoinResultSet.this.nChildren - 1) {
                        ++this.nRows;
                        break;
                    }
                    ++XCrossJoinResultSet.this.current;
                }
                if (XCrossJoinResultSet.this.current == XCrossJoinResultSet.this.nChildren - 1) {
                    XCrossJoinResultSet.this.combine(this.result, XCrossJoinResultSet.this.rowList, XJoin.State.EQUAL);
                    return this.result;
                }
                return null;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (XCrossJoinResultSet.this.tabIt != null) {
                    for (int i = 0; i < XCrossJoinResultSet.this.tabIt.length; ++i) {
                        try {
                            if (XCrossJoinResultSet.this.tabIt[i] == null) continue;
                            XCrossJoinResultSet.this.tabIt[i].release();
                            continue;
                        }
                        catch (Exception ex) {
                            mErrorLogger.log(ex);
                            continue;
                        }
                        finally {
                            ((XCrossJoinResultSet)XCrossJoinResultSet.this).tabIt[i] = null;
                        }
                    }
                    XCrossJoinResultSet.access$402(XCrossJoinResultSet.this, null);
                }
                XCrossJoinResultSet.access$602(XCrossJoinResultSet.this, null);
                super.release();
            }
        }
    }
}

