/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XSetOperator;
import com.cognos.xqe.runtree.relational.util.DuplicateEliminator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.HashKeysSet;
import com.cognos.xqe.runtree.relational.util.IPersistedResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public class XExcept
extends XSetOperator {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XExceptResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501041;
    }

    private final class XExceptResultSet
    extends XSetOperator.ResultSet
    implements ITabularResultSet {
        XExceptResultSet(XDataContext theContext) {
            super(theContext);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XExceptIterator(this.getDataContext());
        }

        private final class XExceptIterator
        extends XTabularIterator {
            private static final long serialVersionUID = 1L;
            private static final int BUILD_INDEX = 1;
            private static final int PROBE_INDEX = 0;
            private ITabularIterator probeIterator;
            private ITabularIterator closeMeToo;
            private RowValue probeRow;
            private IRowsetInfo probeRowsetInfo;
            private IPersistedResultSet probeScan;
            private BuildTable buildTable;

            private XExceptIterator(XDataContext context) {
                super(context, XExcept.this.getId());
                this.closeMeToo = null;
                this.probeRowsetInfo = null;
                this.probeScan = null;
                this.buildTable = null;
                try {
                    this.startTimer();
                    this.probeRowsetInfo = XExceptResultSet.this.iResultSets[0].getTabularRowsetInfo();
                    this.probeIterator = XExceptResultSet.this.iResultSets[0].getTabularIterator();
                    if (!XExcept.this.all) {
                        this.closeMeToo = this.probeIterator;
                        this.probeIterator = new DuplicateEliminator(context, (XTabularIterator)this.closeMeToo, this.probeRowsetInfo);
                    }
                    this.buildTable = new BuildTable();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                while (true) {
                    this.getNextProbeRow();
                    if (this.probeRow == null) {
                        return null;
                    }
                    int match = this.buildTable.matchAndDecrement();
                    if (match == 0) {
                        return this.probeRow;
                    }
                    if (match == 1) continue;
                    if (this.buildTable.lastPartition()) break;
                    this.writeProbeRow();
                }
                return this.probeRow;
            }

            private void writeProbeRow() {
                if (this.probeScan == null) {
                    this.probeScan = new FileBasedPersistedResultSet(this.probeRowsetInfo.getDataType(), this.context);
                }
                this.probeScan.write(this.probeRow);
            }

            private void getNextProbeRow() {
                while (true) {
                    this.probeRow = (RowValue)this.probeIterator.next();
                    if (this.probeRow != null) break;
                    this.probeIterator.release();
                    this.probeIterator = null;
                    if (this.probeScan == null) break;
                    this.probeIterator = this.probeScan.getIterator();
                    this.probeScan = null;
                    if (this.buildTable.lastPartition()) {
                        throw new RuntimeException("Incorrect state - build there is no more build partitions, but the probe table is saved");
                    }
                    this.buildTable.loadNextPartition();
                }
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                this.buildTable.release();
                try {
                    if (this.probeIterator != null) {
                        this.probeIterator.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.probeIterator = null;
                }
                try {
                    if (this.closeMeToo != null) {
                        this.closeMeToo.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.closeMeToo = null;
                }
                if (this.probeScan != null) {
                    this.probeScan.release();
                    this.probeScan = null;
                }
            }

            private class BuildTable {
                private Map<HashKeysSet, long[]> hashMap = null;
                private ITabularIterator buildIterator = null;
                private RowValue buildRow;
                long memory = 0L;
                private boolean useFastHash = true;
                private IRowsetInfo buildRowsetInfo = null;
                private HashKeysSet probeKeys = null;
                private boolean first = true;

                BuildTable() {
                    this.buildRowsetInfo = XExceptResultSet.this.iResultSets[1].getTabularRowsetInfo();
                    for (int i = 0; i < this.buildRowsetInfo.getNumColumns(); ++i) {
                        if (this.buildRowsetInfo.getColumnInfo(i).getDataType().getCCLTypeCode() == XExceptIterator.this.probeRowsetInfo.getColumnInfo(i).getDataType().getCCLTypeCode()) continue;
                        this.useFastHash = false;
                        break;
                    }
                    this.buildIterator = XExceptResultSet.this.iResultSets[1].getTabularIterator();
                    this.hashMap = new THashMap();
                    this.probeKeys = new HashKeysSet(XExceptIterator.this.probeRowsetInfo.getNumColumns(), XExceptIterator.this.getDataContext().getLocalCollator(), this.useFastHash);
                }

                public int matchAndDecrement() {
                    if (this.first) {
                        this.first = false;
                        this.loadNextPartition();
                    }
                    this.probeKeys.set(XExceptIterator.this.probeRow);
                    long[] count = this.hashMap.get(this.probeKeys);
                    if (count == null) {
                        return -1;
                    }
                    if (count[0] == 0L) {
                        return 0;
                    }
                    count[0] = XExcept.this.all ? count[0] - 1L : 0L;
                    return 1;
                }

                public boolean lastPartition() {
                    return this.buildIterator == null;
                }

                private void loadNextPartition() {
                    IPersistedResultSet scan = null;
                    if (this.memory > 0L) {
                        XExceptIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                    this.hashMap.clear();
                    while (true) {
                        try {
                            this.buildRow = (RowValue)this.buildIterator.next();
                        }
                        catch (RuntimeException e) {
                            if (scan != null) {
                                scan.release();
                            }
                            this.release();
                            throw e;
                        }
                        if (this.buildRow == null) {
                            this.buildIterator.release();
                            this.buildIterator = null;
                            if (scan == null) break;
                            this.buildIterator = scan.getIterator();
                            scan = null;
                            break;
                        }
                        HashKeysSet buildKeys = new HashKeysSet(this.buildRow.getNumColumns(), XExceptIterator.this.getDataContext().getLocalCollator(), this.useFastHash);
                        buildKeys.set(this.buildRow);
                        long[] count = this.hashMap.get(buildKeys);
                        if (count != null) {
                            count[0] = count[0] + 1L;
                            continue;
                        }
                        if (scan == null) {
                            boolean forced;
                            long memRequired = buildKeys.sizeOf() + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.ARRAYLIST);
                            boolean bl = forced = this.hashMap.size() == 0;
                            if (XExceptIterator.this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
                                count = new long[]{1L};
                                this.hashMap.put(buildKeys.copy(), count);
                                this.memory += memRequired;
                                continue;
                            }
                            scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XExceptIterator.this.context);
                            scan.write(this.buildRow);
                            continue;
                        }
                        scan.write(this.buildRow);
                    }
                }

                void release() {
                    try {
                        if (this.buildIterator != null) {
                            this.buildIterator.release();
                        }
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.buildIterator = null;
                    }
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XExceptIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                    }
                }
            }
        }
    }
}

