/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.runtree.relational.XLiteral;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XHttpGet
extends XNode
implements IXDataSource {
    private ArrayList<ParameterInfo> paramInfoListForSubstitution;
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATASOURCE = "dataSource";
    private static final String ATTRIBUTE_DBTYPE = "dbType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SUFFIX = "suffix";
    private static final String ATTRIBUTE_PREFIX = "prefix";
    private static final String ELEMENT_PARAMETER = "Parameter";
    private static final String ELEMENT_PARAMETERS = "Parameters";
    private static final String ATTRIBUTE_USEPARAMETERIZEDSQL = "useParameterizedSQL";
    private static final String STRING_VALUE_TRUE = "true";
    private IDataSource dataSource;
    private RowsetInfo rowsetInfo;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        IExecutionEnvironment execEnv = context.getEnvironment();
        IValue queryValue = ((IExecutable)((Object)this.getChild(0))).execute(context);
        String queryString = this.substituteParameterValuesInQueryString(context, queryValue.toString());
        SQLQueryArguments arguments = new SQLQueryArguments(this.dataSource, queryString.toString(), execEnv);
        arguments.setCalculatedRowsetInfo(this.rowsetInfo);
        arguments.setVectorizationContext(this.vContext);
        IRelationalDataProvider provider = ProviderManager.getInstance().getRelationalProvider(this.dataSource.getType());
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.dataSource.getType());
        }
        ITabularResultSet result = null;
        XDataContext subContext = execEnv.pushDataContext();
        subContext.setNodeId(this.getId());
        try {
            result = provider.query(subContext, arguments);
        }
        catch (XQEException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            execEnv.popDataContext(subContext);
        }
        return new TabularHybridResultSet(context, result, this.getId());
    }

    private String substituteParameterValuesInQueryString(XDataContext context, String queryString) {
        StringBuilder out = new StringBuilder(queryString);
        for (ParameterInfo paramInfo : this.paramInfoListForSubstitution) {
            Parameter parameter = context.getParameter(paramInfo.getName());
            String paramName = String.format(":%s:", paramInfo.getName().replace(":", "::"));
            String paramValue = this.generateParamValue(parameter, paramInfo);
            int id = out.indexOf(paramName);
            int length = paramName.length();
            if (id == -1) {
                throw new AssertionError((Object)"Non prompt parameter passed to XHttpGet runtree node!");
            }
            out.replace(id, id + length, paramValue);
        }
        return out.toString();
    }

    private String generateParamValue(Parameter parameter, ParameterInfo paramInfo) {
        StringBuilder out = new StringBuilder("");
        ParameterValues parameterValues = parameter.getParameterValueItems();
        if (parameter.isLiteral() && parameterValues.size() == 1) {
            out.append(parameterValues.getValueLiteral(paramInfo.getValuePrefix(), paramInfo.getValueSuffix(), this.dataSource.getCapabilities()));
        }
        return out.toString();
    }

    @Override
    public int getType() {
        return 501154;
    }

    @Override
    public String getQueryText() {
        IXQEQueryNode child = this.getChild(0);
        if (child.getType() == 501019) {
            return ((XLiteral)child).getValue().getString();
        }
        return "";
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        if (this.dataSource != null) {
            trace.attribute(ATTRIBUTE_DATASOURCE, this.dataSource.getName());
            trace.attribute(ATTRIBUTE_DBTYPE, this.dataSource.getType().toString());
        }
        if (this.vContext != null) {
            this.vContext.dumpInfo(trace);
        }
        this.getRowsetInfo().dumpFormattedXMLResult(trace);
        if (this.paramInfoListForSubstitution != null && this.paramInfoListForSubstitution.size() != 0) {
            trace.beginElement(ELEMENT_PARAMETERS, -1);
            for (ParameterInfo p : this.paramInfoListForSubstitution) {
                trace.beginElement(ELEMENT_PARAMETER, -1);
                trace.attribute(ATTRIBUTE_NAME, p.getName());
                if (p.getValuePrefix().length() > 0) {
                    trace.attribute(ATTRIBUTE_PREFIX, p.getValuePrefix());
                }
                if (p.getValueSuffix().length() > 0) {
                    trace.attribute(ATTRIBUTE_SUFFIX, p.getValueSuffix());
                }
                if (p.getUseParameterizedSQL()) {
                    trace.attribute(ATTRIBUTE_USEPARAMETERIZEDSQL, STRING_VALUE_TRUE);
                }
                trace.endElement();
            }
            trace.endElement();
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String dataSourceName = inputNode.attributeValue(ATTRIBUTE_DATASOURCE);
        IDataSource ds = SQLBinderUtil.findOrCreateDataSource(env, null, dataSourceName, null, null, null);
        this.setDataSource(ds);
        List children = inputNode.elements();
        this.rowsetInfo = new RowsetInfo();
        this.rowsetInfo.capture(env, (Element)children.get(0));
        super.capture(env, inputNode, 1);
        Attribute attribute = inputNode.attribute("id");
        if (attribute != null) {
            this.setNodeId(Integer.parseInt(attribute.getValue()));
        }
        for (Element e : children) {
            if (!e.getName().equals(ELEMENT_PARAMETERS)) continue;
            this.paramInfoListForSubstitution = new ArrayList();
            List parms = e.elements();
            for (Element pe : parms) {
                ParameterInfo pInfo = new ParameterInfo(pe.attributeValue(ATTRIBUTE_NAME));
                String t = pe.attributeValue(ATTRIBUTE_PREFIX);
                if (t != null) {
                    pInfo.setValuePrefix(t);
                }
                if ((t = pe.attributeValue(ATTRIBUTE_SUFFIX)) != null) {
                    pInfo.setValueSuffix(t);
                }
                if ((t = pe.attributeValue(ATTRIBUTE_USEPARAMETERIZEDSQL)) != null) {
                    pInfo.setUseParameterizedSQL(STRING_VALUE_TRUE.equals(t));
                }
                this.paramInfoListForSubstitution.add(pInfo);
            }
        }
    }

    public void setRowsetInfo(RowsetInfo theRowsetInfo) {
        this.rowsetInfo = theRowsetInfo;
    }

    public RowsetInfo getRowsetInfo() {
        return this.rowsetInfo;
    }

    public void setParamInfoListForSubstitution(ArrayList<ParameterInfo> paramInfoList) {
        this.paramInfoListForSubstitution = paramInfoList;
    }

    @Override
    protected void persistElementProperty(XQEPersistContext ctx, String key, Object value) {
        super.persistElementProperty(ctx, key, value);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }
}

