/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XParameter
extends XExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_PARAMETERNAME = "name";
    private String name;
    private String prefix = new String();
    private String suffix = new String();

    @Override
    protected IValue executeImpl(XDataContext context) {
        IValue[] paramValues = context.getParameterValues(this.name);
        if (paramValues.length == 1) {
            IValue val = paramValues[0];
            IDataType dt = val.getDataType();
            if (dt != null && dt.isTextType() && (this.getValuePrefix().length() != 0 || this.getValueSuffix().length() != 0)) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getValuePrefix());
                sb.append(val.toString());
                sb.append(this.getValueSuffix());
                TextValue newVal = (TextValue)val.copy();
                newVal.set(sb.toString());
                return newVal;
            }
            return val;
        }
        ArrayType dType = DataTypeFactory.getArrayType(paramValues[0].getDataType(), paramValues.length);
        ArrayValue arrayParamValues = DataValueFactory.createArrayValue(dType);
        arrayParamValues.set(paramValues);
        return arrayParamValues;
    }

    public void setParameterName(String theName) {
        this.name = theName;
    }

    public String getParameterName() {
        return this.name;
    }

    @Override
    public int getType() {
        return 501048;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_PARAMETERNAME, this.name);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setParameterName(inputNode.attribute(ATTRIBUTE_PARAMETERNAME).getValue());
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_PARAMETERNAME, this.name);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_PARAMETERNAME)) {
            Object val = ctx.attributeValue(att);
            this.name = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    public void setValuePrefix(String p) {
        this.prefix = p;
    }

    public String getValuePrefix() {
        return this.prefix;
    }

    public void setValueSuffix(String s) {
        this.suffix = s;
    }

    public String getValueSuffix() {
        return this.suffix;
    }
}

