/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.IScalarFunction;
import com.cognos.xqe.function.udf.UDAggregateFunction;
import com.cognos.xqe.function.udf.UDScalarFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XScalarFunction
extends XExpression
implements IParameterEvaluator {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ATTRIBUTE_FUNCTION = "function";
    private static final String ATTRIBUTE_ISUDF = "isUDF";
    private static final String ATTRIBUTE_ON_ERROR_POLICY = "onErrorPolicy";
    private static final String VALUE_TRUE = "true";
    protected IScalarFunction function;
    protected SQLAbstractFunction.OnErrorPolicy onErrorPolicy;

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        super.open(context, rowsetInfo);
        this.getDataType(rowsetInfo, -1);
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        if (this.dataType.isVariant()) {
            IDataType[] argTypes = new IDataType[this.getParameterCount()];
            for (int i = 0; i < this.getParameterCount(); ++i) {
                argTypes[i] = this.getParameter(context, i).getDataType();
            }
            this.function.validateArgumentTypesImpl(argTypes);
            this.dataType = this.function.getResultDataType(argTypes);
        }
        IValue value = context.getValue(this, this.dataType);
        this.function.execute(context, (IParameterEvaluator)this, value);
        return value;
    }

    @Override
    public int getParameterCount() {
        return this.getNumberChildren();
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        return ((XExpression)this.getChild(index)).execute(context);
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        int nChildren = this.getNumberChildren();
        IValue[] pValues = new IValue[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            pValues[i] = this.getParameter(context, i);
        }
        return pValues;
    }

    @Override
    public String getParameterName(int index) {
        return ((XExpression)this.getChild(index)).getName(null, index);
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return this.getChild(index).getType() == 501019;
    }

    @Override
    public IDataType getParameterType(int index) {
        return ((XExpression)this.getChild(index)).getDataType();
    }

    @Override
    public int getType() {
        return 501020;
    }

    @Override
    public String getNameImpl(IRowsetInfo rowsetInfo, int index) {
        return this.function.toString() + index;
    }

    public void setFunction(IScalarFunction theFunction) {
        this.function = theFunction;
    }

    public IFunction getFunction() {
        return this.function;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_FUNCTION, this.function.toString());
        if (this.onErrorPolicy != null) {
            trace.attribute(ATTRIBUTE_ON_ERROR_POLICY, this.onErrorPolicy.getOnErrorPolicyValue());
        }
        if (this.dataType != null) {
            trace.attribute(ATTRIBUTE_DATATYPE, this.dataType.toString());
        }
        if (this.function instanceof UDScalarFunction) {
            trace.attribute(ATTRIBUTE_ISUDF, VALUE_TRUE);
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String fName = inputNode.attribute(ATTRIBUTE_FUNCTION).getStringValue();
        boolean isUDF = false;
        Attribute isUDFattr = inputNode.attribute(ATTRIBUTE_ISUDF);
        if (isUDFattr != null) {
            isUDF = isUDFattr.getValue().equalsIgnoreCase(VALUE_TRUE);
        }
        String onErrorPolicyValue = inputNode.attributeValue(ATTRIBUTE_ON_ERROR_POLICY);
        if (SQLAbstractFunction.OnErrorPolicy.ERROR.getOnErrorPolicyValue().equals(onErrorPolicyValue)) {
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.ERROR;
        } else if (SQLAbstractFunction.OnErrorPolicy.NULL.getOnErrorPolicyValue().equals(onErrorPolicyValue)) {
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.NULL;
        }
        super.capture(env, inputNode);
        int nChildren = this.getNumberChildren();
        if (isUDF) {
            IDataType[] argTypes = new IDataType[nChildren];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = DataTypeFactory.getVariantType();
            }
            this.function = (IScalarFunction)FunctionManager.getUserDefinedFunction(fName, argTypes);
        } else {
            this.function = (IScalarFunction)FunctionManager.getBuiltinFunction(fName);
        }
        if (this.function == null) {
            throw new UnsupportedOperationException(fName);
        }
        this.setDataType(DataTypeFactory.getType(inputNode.attribute(ATTRIBUTE_DATATYPE).getValue()));
    }

    @Override
    public IDataType getDataType(IRowsetInfo rowsetInfo, int index) {
        if (this.dataType.getCCLTypeCode() != 22) {
            return this.dataType;
        }
        IDataType[] arguments = new IDataType[this.getNumberChildren()];
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            arguments[i] = ((IXExpression)((Object)this.getChild(i))).getDataType(rowsetInfo, i);
        }
        this.dataType = this.getFunction().getResultDataType(arguments);
        return this.dataType;
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.function != null) {
            ctx.property(ATTRIBUTE_FUNCTION, this.function.toString());
            if (this.function instanceof UDAggregateFunction) {
                ctx.attribute(ATTRIBUTE_ISUDF, VALUE_TRUE);
            }
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_FUNCTION)) {
            boolean isUDF = false;
            Attribute isUDFattr = inputNode.attribute(ATTRIBUTE_ISUDF);
            if (isUDFattr != null) {
                isUDF = (Boolean)ctx.attributeValue(isUDFattr);
            }
            String fname = (String)ctx.attributeValue(att);
            if (isUDF) {
                IDataType[] argTypes = null;
                this.function = (IScalarFunction)FunctionManager.getUserDefinedFunction(fname, argTypes);
            } else {
                this.function = (IScalarFunction)FunctionManager.getBuiltinFunction(fname);
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        super.restoreChildren(ctx, node);
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        return this.onErrorPolicy;
    }

    public void setOnErrorPolicy(SQLAbstractFunction.OnErrorPolicy oep) {
        this.onErrorPolicy = oep;
    }
}

