/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XSearch
extends XExpression {
    private static final long serialVersionUID = 1L;
    private static final long MAX_AVALIABLE_MEMORY_SIZE = 10000000L;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private AtomicInteger refCount = new AtomicInteger(0);
    private FileBasedPersistedResultSet sharedBucket;
    private boolean hasNulls = false;
    private NavigableMap<IValue, SearchSet> indexManager = new TreeMap<IValue, SearchSet>();
    private SearchSet lastSearchSet;

    public XSearch() {
        this.setDataType(DataTypeFactory.getBooleanType());
    }

    @Override
    public int getType() {
        return 501098;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        try {
            this.lock.writeLock().lockInterruptibly();
            try {
                IHybridResultSet resultSet = (IHybridResultSet)((IExecutable)((Object)this.getChild(1))).execute(context);
                this.loadRowsForSearch(context, resultSet);
                resultSet.release();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            throw new RequestCanceledException();
        }
        this.refCount.incrementAndGet();
    }

    @Override
    protected IValue executeImpl(XDataContext context) {
        Value value = (Value)context.getValue(this, this.dataType);
        IRow keyValue = (IRow)((IExecutable)((Object)this.getChild(0))).execute(context);
        boolean found = false;
        Map.Entry<IValue, SearchSet> indexEntry = this.indexManager.floorEntry(keyValue);
        if (indexEntry != null) {
            SearchSet aSearchSet = indexEntry.getValue();
            if (aSearchSet == null) {
                found = false;
            } else {
                if (aSearchSet != this.lastSearchSet) {
                    this.lastSearchSet.evict();
                }
                found = aSearchSet.contains(keyValue);
                this.lastSearchSet = aSearchSet;
            }
        }
        if (!found && this.hasNulls) {
            value.setNull();
        } else {
            value.set(found);
        }
        return value;
    }

    @Override
    public void close(XDataContext context) {
        this.refCount.decrementAndGet();
        if (this.refCount.get() > 0) {
            return;
        }
        if (this.sharedBucket != null) {
            this.sharedBucket.release();
            this.sharedBucket = null;
        }
        if (this.indexManager != null) {
            this.indexManager.clear();
        }
        if (this.lastSearchSet != null) {
            this.lastSearchSet.evict();
            this.lastSearchSet = null;
        }
    }

    private void loadRowsForSearch(XDataContext context, IHybridResultSet aResultSet) {
        SearchSet aSearchSet;
        XTabularIterator tabIt = (XTabularIterator)aResultSet.getTabularIterator();
        ArrayList<IRow> valueInMemory = new ArrayList<IRow>();
        IRow inputRow = (IRow)tabIt.next();
        long searchSetMemorySize = 0L;
        IRow firstValue = null;
        long position = -1L;
        int rowCount = 0;
        while (inputRow != null) {
            if (!((RowValue)inputRow).containsNull().booleanValue()) {
                if (searchSetMemorySize + (long)inputRow.sizeOf() < 10000000L) {
                    searchSetMemorySize += (long)inputRow.sizeOf();
                    if (this.sharedBucket == null) {
                        valueInMemory.add(inputRow);
                    } else {
                        ++rowCount;
                        this.sharedBucket.write(inputRow);
                    }
                } else {
                    if (this.sharedBucket == null) {
                        this.sharedBucket = new FileBasedPersistedResultSet(aResultSet.getTabularRowsetInfo().getDataType(), context, false);
                        aSearchSet = new SearchSet(valueInMemory.toArray(new IRow[valueInMemory.size()]));
                        firstValue = (IRow)valueInMemory.get(0);
                        this.lastSearchSet = aSearchSet;
                    } else {
                        aSearchSet = new SearchSet(position, rowCount);
                    }
                    this.indexManager.put(firstValue, aSearchSet);
                    firstValue = inputRow instanceof RowValue ? (IRow)((RowValue)inputRow).copy(false) : (IRow)inputRow.copy();
                    position = this.sharedBucket.write(inputRow);
                    rowCount = 1;
                    searchSetMemorySize = inputRow.sizeOf();
                }
            } else {
                this.hasNulls = true;
            }
            inputRow = (IRow)tabIt.next();
        }
        if (!valueInMemory.isEmpty()) {
            if (this.sharedBucket == null) {
                aSearchSet = new SearchSet(valueInMemory.toArray(new IRow[valueInMemory.size()]));
                firstValue = (IRow)valueInMemory.get(0);
                this.lastSearchSet = aSearchSet;
            } else {
                aSearchSet = new SearchSet(position, rowCount);
            }
            this.indexManager.put(firstValue, aSearchSet);
        }
        tabIt.release();
        valueInMemory.clear();
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private class SearchSet {
        IRow[] values = null;
        int rowCount;
        long firstRowOffSet = -1L;
        private XTabularIterator iterator;

        SearchSet(long filePosition, int numberOfRows) {
            this.firstRowOffSet = filePosition;
            this.rowCount = numberOfRows;
        }

        SearchSet(IRow[] valueList) {
            this.rowCount = valueList.length;
            if (XSearch.this.sharedBucket != null) {
                for (IRow value : valueList) {
                    if (this.firstRowOffSet < 0L) {
                        this.firstRowOffSet = XSearch.this.sharedBucket.write(value);
                        continue;
                    }
                    XSearch.this.sharedBucket.write(value);
                }
            }
            this.values = new IRow[this.rowCount];
            for (int i = 0; i < this.rowCount; ++i) {
                this.values[i] = valueList[i];
            }
        }

        public boolean contains(IRow value) {
            boolean found = false;
            if (this.values == null) {
                this.iterator = XSearch.this.sharedBucket.getIterator(this.firstRowOffSet);
                this.values = new IRow[this.rowCount];
                for (int i = 0; i < this.rowCount; ++i) {
                    IRow currentRow = (IRow)this.iterator.next();
                    if (currentRow.compareTo(value) == 0) {
                        found = true;
                    }
                    this.values[i] = currentRow instanceof RowValue ? (IRow)((RowValue)currentRow).copy(false) : (IRow)currentRow.copy();
                }
                this.iterator.release();
                return found;
            }
            return Arrays.binarySearch(this.values, value) >= 0;
        }

        public void evict() {
            this.values = null;
        }
    }
}

