/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XEnqueue;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XSetOperator
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    protected static final String ATTRIBUTE_ALL = "all";
    protected boolean all;

    public void setAll(boolean keepDuplicates) {
        this.all = keepDuplicates;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void dumpExtraInfo(XQETrace traceObj, boolean includeRuntimeSpecifics) {
        traceObj.attribute(ATTRIBUTE_ALL, this.all);
        if (this.vContext != null) {
            this.vContext.dumpInfo(traceObj);
        }
        super.dumpExtraInfo(traceObj, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setAll(Boolean.valueOf(inputNode.attributeValue(ATTRIBUTE_ALL)));
        super.capture(env, inputNode);
    }

    boolean isFastHashApplicable(ITabularResultSet[] allRS, IRowsetInfo rowsetInfo) {
        IDataType rDataType = rowsetInfo.getDataType();
        for (ITabularResultSet rs : allRS) {
            if (rDataType.exactlyEquivalent(rs.getTabularRowsetInfo().getDataType())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_ALL, this.all);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_ALL)) {
            Object val = ctx.attributeValue(att);
            this.all = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    protected class ResultSet
    extends XResultSetBase {
        protected IHybridResultSet[] iResultSets;

        protected ResultSet(XDataContext context) {
            super(context, XSetOperator.this.getId());
            int nChildren = XSetOperator.this.getNumberChildren();
            try {
                this.iResultSets = new IHybridResultSet[nChildren];
                this.iResultSets[0] = (IHybridResultSet)((IExecutable)((Object)XSetOperator.this.getChild(0))).execute(this.getDataContext());
                this.rowsetInfo = new RowsetInfo();
                this.rowsetInfo.copyFrom(this.iResultSets[0].getTabularRowsetInfo());
                IXQEQueryNode parent = XSetOperator.this.getParent();
                if (parent != null && parent.getType() == 501035) {
                    context.setRowsetInfo(((XEnqueue)parent).getQueueName(), this.rowsetInfo);
                }
                boolean multipleDataSources = context.getEnvironment().getDataSources().size() > 1;
                for (int i = 1; i < this.iResultSets.length; ++i) {
                    if (multipleDataSources) {
                        context.setInterpreterContext(null);
                    }
                    this.iResultSets[i] = (IHybridResultSet)((IExecutable)((Object)XSetOperator.this.getChild(i))).execute(this.getDataContext());
                    IRowsetInfo tmpRowsetInfo = this.iResultSets[i].getTabularRowsetInfo();
                    for (int j = 0; j < this.rowsetInfo.getNumColumns(); ++j) {
                        ColumnInfo columnInfo = (ColumnInfo)this.rowsetInfo.getColumnInfo(j);
                        byte dt1 = columnInfo.getDataType().getCCLTypeCode();
                        byte dt2 = tmpRowsetInfo.getColumnInfo(j).getDataType().getCCLTypeCode();
                        if (dt1 == 22) {
                            columnInfo.setDataType(tmpRowsetInfo.getColumnInfo(j).getDataType());
                            continue;
                        }
                        if (dt2 == 22) {
                            tmpRowsetInfo.getColumnInfo(j).setDataType(columnInfo.getDataType());
                            continue;
                        }
                        columnInfo.setDataType(DataTypeComparator.getCompatibleType(columnInfo.getDataType(), tmpRowsetInfo.getColumnInfo(j).getDataType()));
                    }
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSets != null) {
                ResultSet.releaseNonNullReleasables((IReleasable[])this.iResultSets);
                this.iResultSets = null;
                this.rowsetInfo = null;
            }
        }
    }
}

