/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.RequestCanceledException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.ScrollableTabularCache;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XStore
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FETCHALL = "fetchAll";
    protected ScrollableTabularCache cache;
    private ITabularResultSet iResultSet;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    protected AtomicInteger refCount = new AtomicInteger(0);
    private boolean fetchAll;
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XStoreResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501032;
    }

    @Override
    protected void capture(PlanningEnvironment env, Element inputNode, int start) {
        this.fetchAll = Boolean.valueOf(inputNode.attributeValue(ATTRIBUTE_FETCHALL));
        super.capture(env, inputNode, start);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        super.restoreAttributeProperty(ctx, att, inputNode);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    private final class XStoreResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        XStoreResultSet(XDataContext context) {
            super(context, XStore.this.getId());
            XStore.this.refCount.incrementAndGet();
            try {
                XStore.this.lock.writeLock().lockInterruptibly();
                try {
                    if (XStore.this.iResultSet == null) {
                        XStore.this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XStore.this.getChild(0))).execute(context);
                    }
                }
                finally {
                    XStore.this.lock.writeLock().unlock();
                }
            }
            catch (InterruptedException e) {
                throw new RequestCanceledException();
            }
            IRowsetInfo rowsetInfo = XStore.this.iResultSet.getTabularRowsetInfo();
            super.setTabularRowsetInfo(rowsetInfo);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XStoreIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            block12: {
                XStore.this.refCount.decrementAndGet();
                try {
                    XStore.this.lock.writeLock().lockInterruptibly();
                    try {
                        if (XStore.this.refCount.get() != 0) break block12;
                        if (XStore.this.cache != null) {
                            try {
                                XStore.this.cache.release();
                            }
                            catch (Exception e) {
                                mErrorLogger.log(e);
                            }
                            finally {
                                XStore.this.cache = null;
                            }
                        }
                        if (XStore.this.iResultSet != null) {
                            XStore.this.iResultSet.release();
                            XStore.this.iResultSet = null;
                        }
                    }
                    finally {
                        XStore.this.lock.writeLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    throw new RequestCanceledException();
                }
            }
            this.rowsetInfo = null;
        }

        private final class XStoreIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;

            protected XStoreIterator(XDataContext context) {
                super(context, XStore.this.getId());
                try {
                    this.startTimer();
                    try {
                        XStore.this.lock.writeLock().lockInterruptibly();
                        try {
                            if (XStore.this.cache == null) {
                                XStore.this.cache = new ScrollableTabularCache(context, XStore.this.iResultSet, XStore.this.fetchAll);
                            }
                        }
                        finally {
                            XStore.this.lock.writeLock().unlock();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RequestCanceledException();
                    }
                    this.tabIt = XStore.this.cache.getTabularIterator(context);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                IRow inputRow = (IRow)this.tabIt.next();
                if (inputRow == null) {
                    this.tabIt.reset();
                } else {
                    ++this.nRows;
                }
                return inputRow;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

