/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ITableFunction;
import com.cognos.xqe.function.json.JSONTable;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.caching.CachedResultSet;
import com.cognos.xqe.resultsets.caching.CachedTabularResultSet;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XLiteral;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public class XTableFunction
extends XTabularResultSet
implements IParameterEvaluator,
IXDataSource,
IVectorContext {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FUNCTION = "function";
    private static final String ATTRIBUTE_IS_NESTED = "isNested";
    private static final String ATTRIBUTE_ON_ERROR_POLICY = "onErrorPolicy";
    private static final String CURSOR_FUNCTION = "Cursor";
    private static final String ELEMENT_ROWSETINFO = "RowsetInfo";
    private static final String EMPTY_STR = "";
    private static final String STRING_PROPERTY_EXECUTION_TREE = "executionTree";
    private ITableFunction function;
    private XNode executionTree = null;
    private IDataSource dataSource;
    private IDataType dataType;
    private boolean isNested;
    private SQLAbstractFunction.OnErrorPolicy onErrorPolicy;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XTableFunctionResultSet(context), this.getId());
    }

    public void setFunction(IFunction theFunction) {
        this.function = (ITableFunction)theFunction;
    }

    public void setDatasource(IDataSource aDataSource) {
        this.dataSource = aDataSource;
    }

    public void setDataType(IDataType dType) {
        this.dataType = dType;
    }

    public IDataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getType() {
        return 501015;
    }

    public void setIsNested(boolean value) {
        this.isNested = value;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public boolean isFlatTableFunction() {
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof XTableFunction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List children = inputNode.elements();
        int nChildren = children.size();
        if (nChildren > 0) {
            Element child = (Element)children.get(0);
            if (child.getName().equals(ELEMENT_ROWSETINFO)) {
                RowsetInfo rowsetInfo = new RowsetInfo();
                rowsetInfo.capture(env, (Element)children.get(0));
                this.dataType = rowsetInfo.getDataType();
                --nChildren;
                super.capture(env, inputNode, 1);
            } else {
                super.capture(env, inputNode, 0);
            }
        }
        IDataType[] argTypes = new IDataType[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            argTypes[i] = ((IXExpression)((Object)this.getChild(i))).getDataType();
        }
        String fName = inputNode.attributeValue(ATTRIBUTE_FUNCTION);
        this.function = (ITableFunction)FunctionManager.getFunction(fName, argTypes);
        if (this.function == null) {
            throw new UnsupportedOperationException(fName);
        }
        if (this.dataType == null) {
            this.dataType = this.function.getResultDataType(argTypes);
        }
        this.isNested = Boolean.getBoolean(inputNode.attributeValue(ATTRIBUTE_IS_NESTED));
        String onErrorPolicyValue = inputNode.attributeValue(ATTRIBUTE_ON_ERROR_POLICY);
        if (SQLAbstractFunction.OnErrorPolicy.ERROR.getOnErrorPolicyValue().equals(onErrorPolicyValue)) {
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.ERROR;
        } else if (SQLAbstractFunction.OnErrorPolicy.NULL.getOnErrorPolicyValue().equals(onErrorPolicyValue)) {
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.NULL;
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_FUNCTION, this.function.getName());
        trace.attribute(ATTRIBUTE_IS_NESTED, this.isNested);
        if (this.onErrorPolicy != null) {
            trace.attribute(ATTRIBUTE_ON_ERROR_POLICY, this.onErrorPolicy.getOnErrorPolicyValue());
        }
        if (this.vContext != null) {
            this.vContext.dumpInfo(trace);
        }
        if (this.dataType instanceof RowType) {
            ((RowType)this.dataType).getRowsetInfo().dumpFormattedXMLResult(trace);
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public int getParameterCount() {
        return this.getNumberChildren();
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        return ((IExecutable)((Object)this.getChild(index))).execute(context);
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        int nChildren = this.getNumberChildren();
        IValue[] pValues = new IValue[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            pValues[i] = this.getParameter(context, i);
        }
        return pValues;
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return false;
    }

    @Override
    public IDataType getParameterType(int index) {
        return null;
    }

    public IFunction getFunction() {
        return this.function;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public boolean loadInBackground() {
        IExecutionEnvironment execEnv;
        Object reqEnv;
        ITabularResultSet rs;
        boolean ret = false;
        if (this.getFunction().getName().equals(CURSOR_FUNCTION) && (rs = (reqEnv = (execEnv = ExecutionEnvironmentContext.getExecutionEnvironment()).getRequestEnvironment()).getQueryReuseManager().getResultSet((IQueryReuseManager.CursorInfo)((XLiteral)this.getChild(0)).getValue().getObject(), execEnv.getDataContext())) instanceof CachedTabularResultSet) {
            ((CachedTabularResultSet)rs).loadInBackground();
            ret = true;
        }
        return ret;
    }

    @Override
    public IDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getQueryText() {
        if (!(this.function instanceof JSONTable)) {
            return EMPTY_STR;
        }
        XLiteral xLiteral = (XLiteral)this.getChild(0);
        String content = xLiteral.getValue().getString();
        JSONObject jObject = null;
        try {
            jObject = JSONObject.parse((String)content);
        }
        catch (IOException e) {
            return EMPTY_STR;
        }
        String method = (String)jObject.get((Object)"METHOD");
        if (method.equals("GET")) {
            return (String)jObject.get((Object)"URL");
        }
        String data = (String)jObject.get((Object)"DATA");
        if (data == null) {
            return EMPTY_STR;
        }
        return JSONUtil.prettyPrint(data);
    }

    public XNode getSubTree() {
        return this.executionTree;
    }

    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        for (IXQEQueryNode child : this.getChildren()) {
            if (child instanceof IXExpression) {
                ((IXExpression)((Object)child)).open(context, rowsetInfo);
                continue;
            }
            ((XTableFunction)child).open(context, rowsetInfo);
        }
    }

    public void close(XDataContext context) {
        for (IXQEQueryNode child : this.getChildren()) {
            if (child instanceof IXExpression) {
                ((IXExpression)((Object)child)).close(context);
                continue;
            }
            ((XTableFunction)child).close(context);
        }
    }

    public void setSubTree(XNode execTree) {
        this.executionTree = execTree;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.function != null) {
            ctx.property(ATTRIBUTE_FUNCTION, this.function.getName());
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.dataType instanceof RowType) {
            ((RowType)this.dataType).getRowsetInfo().persist(ctx, ELEMENT_ROWSETINFO);
        }
        if (this.executionTree != null) {
            ctx.elementProperty(STRING_PROPERTY_EXECUTION_TREE, this.executionTree);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null) {
            if (pname.equals(STRING_PROPERTY_EXECUTION_TREE)) {
                Object value = ctx.elementValue(node);
                this.executionTree = (XNode)value;
            } else if (pname.equals(ELEMENT_ROWSETINFO)) {
                Object value = ctx.elementValue(node);
                RowsetInfo rowsetInfo = (RowsetInfo)value;
                this.dataType = rowsetInfo.getDataType();
            } else {
                super.restoreElementProperty(ctx, node, inputNode);
            }
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    @Override
    protected void restoreChildren(XQERestoreContext ctx, Element node) {
        super.restoreChildren(ctx, node);
        int nChildren = this.getChildren().length;
        IDataType[] argTypes = new IDataType[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            argTypes[i] = ((IXExpression)((Object)this.getChild(i))).getDataType();
        }
        String fName = node.attributeValue(ATTRIBUTE_FUNCTION);
        this.function = (ITableFunction)FunctionManager.getFunction(fName, argTypes);
        if (this.function != null && this.dataType == null) {
            this.dataType = this.function.getResultDataType(argTypes);
        }
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        return this.onErrorPolicy;
    }

    public void setOnErrorPolicy(SQLAbstractFunction.OnErrorPolicy oep) {
        this.onErrorPolicy = oep;
    }

    private final class XTableFunctionResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private ITabularResultSet result;

        XTableFunctionResultSet(XDataContext context) {
            super(context, XTableFunction.this.getId());
            this.rowsetInfo = ((RowType)XTableFunction.this.dataType).getRowsetInfo();
            if (XTableFunction.this.dataSource != null) {
                ConnectionUtil.connect(context.getEnvironment(), XTableFunction.this.dataSource);
            }
            for (IXQEQueryNode child : XTableFunction.this.getChildren()) {
                if (child instanceof IXExpression) {
                    ((IXExpression)((Object)child)).open(context, this.rowsetInfo);
                    continue;
                }
                ((XTableFunction)child).open(context, this.rowsetInfo);
            }
            this.result = XTableFunction.this.function.execute(context, XTableFunction.this, this.rowsetInfo);
            IRowsetInfo iRowsetInfo = this.result.getTabularRowsetInfo();
            for (int i = 0; i < this.rowsetInfo.getNumColumns(); ++i) {
                IColumnInfo columnInfo = this.rowsetInfo.getColumnInfo(i);
                columnInfo.setDataType(iRowsetInfo.getColumnInfo(i).getDataType());
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            Object reqEnv = this.getDataContext().getEnvironment().getRequestEnvironment();
            try {
                if (this.result instanceof CachedResultSet) {
                    return ((CachedResultSet)this.result).getTabularIterator(XTableFunction.this.vContext);
                }
                return this.result.getTabularIterator();
            }
            catch (LogonFailureException e) {
                e.setDataSource(XTableFunction.this.dataSource);
                throw e;
            }
            catch (XQERuntimeException e) {
                if (XTableFunction.this.getFunction().getName().equals(XTableFunction.CURSOR_FUNCTION)) {
                    reqEnv.getQueryReuseManager().removeQueryByName(((XLiteral)XTableFunction.this.getChild(0)).getValue().getString());
                }
                throw e;
            }
        }

        @Override
        public void releaseImpl() {
            for (IXQEQueryNode child : XTableFunction.this.getChildren()) {
                if (child instanceof IXExpression) {
                    ((IXExpression)((Object)child)).close(this.getDataContext());
                    continue;
                }
                ((XTableFunction)child).close(this.getDataContext());
            }
            this.result.release();
            if (XTableFunction.this.getFunction().getName().equals(XTableFunction.CURSOR_FUNCTION)) {
                IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
                Governors gvr = execEnv.getGovernors();
                if (gvr == null) {
                    return;
                }
                switch (gvr.getCursorMode()) {
                    case CURSOR_MODE_QUERY_PER_PAGE: {
                        Object reqEnv = execEnv.getRequestEnvironment();
                        reqEnv.getQueryReuseManager().removeQueryByName(((XLiteral)XTableFunction.this.getChild(0)).getValue().getString());
                        break;
                    }
                }
            }
        }
    }
}

