/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XSetOperator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class XUnion
extends XSetOperator {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XUnionResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501016;
    }

    private final class XUnionResultSet
    extends XSetOperator.ResultSet
    implements ITabularResultSet {
        XUnionResultSet(XDataContext theContext) {
            super(theContext);
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XUnionIterator(this.getDataContext());
        }

        private final class XUnionIterator
        extends XTabularIterator {
            private ITabularResultSet[] children;
            private XTabularIterator tabIt;
            private RowValue row;
            private int current;

            private XUnionIterator(XDataContext context) {
                super(context, XUnion.this.getId());
                try {
                    this.startTimer();
                    this.children = XUnionResultSet.this.iResultSets;
                    this.tabIt = (XTabularIterator)XUnionResultSet.this.iResultSets[0].getTabularIterator();
                    this.row = DataValueFactory.createRowValue(context.getLocalCollator(), XUnionResultSet.this.rowsetInfo);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                IRow inputRow = null;
                while (this.tabIt != null) {
                    inputRow = (IRow)this.tabIt.next();
                    if (inputRow != null) {
                        this.row.copyFrom(inputRow);
                        ++this.nRows;
                        break;
                    }
                    if (++this.current < XUnion.this.getNumberChildren()) {
                        if (this.tabIt != null) {
                            this.tabIt.release();
                        }
                        this.tabIt = (XTabularIterator)this.children[this.current].getTabularIterator();
                        continue;
                    }
                    return null;
                }
                return this.row;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

