/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.dataset;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIdentifier;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.data.types.CharType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.NCharType;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.SimpleParameterValueItem;
import com.cognos.xqe.runtree.XDataContext;
import com.ibm.bi.platform.datasetutils.parquet.ParquetOptions;
import com.ibm.bi.platform.datasetutils.utils.DateTimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.io.api.Binary;

public final class ParquetFilters {
    private ParquetFilters() {
    }

    public static FilterPredicate buildFilterPredicate(XDataContext context, IXQEQueryNode condition, ParquetOptions pqOptions) {
        switch (condition.getType()) {
            case 301027: {
                return ParquetFilters.buildSQLLogical(context, (SQLLogical)condition, pqOptions);
            }
            case 301026: {
                return ParquetFilters.buildSQLComparision(context, (SQLComparison)condition, pqOptions);
            }
        }
        throw new UnsupportedOperationException("Unsupported condition type: " + condition.dumpToString());
    }

    static FilterPredicate buildSQLLogical(XDataContext context, SQLLogical logical, ParquetOptions pqOptions) {
        SQLLogical.SubType subType = logical.getSubType();
        if (subType == SQLLogical.SubType.NOT) {
            FilterPredicate operand = ParquetFilters.buildFilterPredicate(context, logical.getChild(0), pqOptions);
            return FilterApi.not((FilterPredicate)operand);
        }
        if (subType == SQLLogical.SubType.AND || subType == SQLLogical.SubType.OR) {
            FilterPredicate left = ParquetFilters.buildFilterPredicate(context, logical.getChild(0), pqOptions);
            FilterPredicate right = ParquetFilters.buildFilterPredicate(context, logical.getChild(1), pqOptions);
            if (subType == SQLLogical.SubType.AND) {
                return FilterApi.and((FilterPredicate)left, (FilterPredicate)right);
            }
            return FilterApi.or((FilterPredicate)left, (FilterPredicate)right);
        }
        throw new UnsupportedOperationException("Unsupported logical type: " + logical.dumpToString());
    }

    static FilterPredicate buildSQLComparision(XDataContext context, SQLComparison comparison, ParquetOptions pqOptions) {
        Value value;
        SQLIdentifier fid = (SQLIdentifier)comparison.getChild(0);
        IXQEQueryNode rightChild = comparison.getChild(1);
        if (rightChild.getType() == 301051) {
            String parameterName = ((SQLParameter)rightChild).getName();
            Parameter parameter = context.getParameter(parameterName);
            ParameterValues paramValues = parameter.getParameterValueItems();
            SimpleParameterValueItem paramValueItem = (SimpleParameterValueItem)paramValues.get(0);
            value = (Value)paramValueItem.getValueFromInternalValue();
        } else {
            value = ((SQLLiteral)rightChild).getValue();
        }
        IDataType dType = fid.getDataType() != null ? fid.getDataType() : value.getDataType();
        int precision = dType.getPrecision();
        String columnName = fid.getName();
        SQLComparison.SubType opType = comparison.getSubType();
        switch (dType.getCCLTypeCode()) {
            case 2: 
            case 4: 
            case 6: {
                return ParquetFilters.buildComparisonOperator(FilterApi.intColumn((String)columnName), value.getInteger(), opType);
            }
            case 8: {
                return ParquetFilters.buildComparisonOperator(FilterApi.longColumn((String)columnName), value.getLong(), opType);
            }
            case 10: {
                return ParquetFilters.buildComparisonOperator(FilterApi.floatColumn((String)columnName), Float.valueOf(value.getFloat()), opType);
            }
            case 11: {
                return ParquetFilters.buildComparisonOperator(FilterApi.doubleColumn((String)columnName), value.getDouble(), opType);
            }
            case 12: 
            case 54: {
                return ParquetFilters.buildDecimalComparisonOperator(columnName, precision, value, opType, pqOptions);
            }
            case 57: {
                return ParquetFilters.buildDateComparisonOperator(columnName, (DateValue)value, opType, pqOptions);
            }
            case 58: 
            case 59: {
                return ParquetFilters.buildDateTimeComparisonOperator(columnName, (DateTimeValue)value, opType, pqOptions);
            }
            case 1: 
            case 45: 
            case 55: 
            case 56: {
                String strValue = value.getString();
                if (dType instanceof CharType || dType instanceof NCharType) {
                    int maxLength = dType.getPrecision();
                    if (strValue.length() < maxLength) {
                        StringBuilder b = new StringBuilder(maxLength);
                        b.append(strValue);
                        int padChars = maxLength - strValue.length();
                        for (int k = 0; k < padChars; ++k) {
                            b.append(' ');
                        }
                        strValue = b.toString();
                    }
                }
                return ParquetFilters.buildComparisonOperator(FilterApi.binaryColumn((String)columnName), Binary.fromString((String)strValue), opType);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dType.toString());
    }

    static FilterPredicate buildDecimalComparisonOperator(String columnName, int precision, Value value, SQLComparison.SubType subType, ParquetOptions pqOptions) {
        if (precision <= 9) {
            return ParquetFilters.buildComparisonOperator(FilterApi.intColumn((String)columnName), value.getInteger(), subType);
        }
        if (precision <= 18) {
            return ParquetFilters.buildComparisonOperator(FilterApi.longColumn((String)columnName), value.getLong(), subType);
        }
        if (pqOptions.isDecimalAsStringEnabled()) {
            return ParquetFilters.buildComparisonOperator(FilterApi.binaryColumn((String)columnName), Binary.fromString((String)value.getString()), subType);
        }
        byte[] uncaledBytes = value.getBigDecimal().unscaledValue().toByteArray();
        return ParquetFilters.buildComparisonOperator(FilterApi.binaryColumn((String)columnName), Binary.fromConstantByteArray((byte[])uncaledBytes), subType);
    }

    static FilterPredicate buildDateComparisonOperator(String columnName, DateValue value, SQLComparison.SubType subType, ParquetOptions pqOptions) {
        if (pqOptions.isDateAsEpochMillisEnabled()) {
            return ParquetFilters.buildComparisonOperator(FilterApi.longColumn((String)columnName), value.getMilliseconds(), subType);
        }
        LocalDate localDate = value.getJdbcDate().toLocalDate();
        return ParquetFilters.buildComparisonOperator(FilterApi.intColumn((String)columnName), (int)localDate.toEpochDay(), subType);
    }

    static FilterPredicate buildDateTimeComparisonOperator(String columnName, DateTimeValue value, SQLComparison.SubType subType, ParquetOptions pqOptions) {
        if (pqOptions.isTimestampAsGroupEnabled()) {
            long milliseconds = value.getMilliseconds();
            int nanoseconds = value.getNanoseconds();
            return FilterApi.and((FilterPredicate)ParquetFilters.buildComparisonOperator(FilterApi.longColumn((String)(columnName + ".ms")), milliseconds, subType), (FilterPredicate)ParquetFilters.buildComparisonOperator(FilterApi.intColumn((String)(columnName + ".ns")), nanoseconds, subType));
        }
        if (value.getDataType().isTime()) {
            LocalTime localTime = value.getTime().toLocalTime();
            return ParquetFilters.buildComparisonOperator(FilterApi.binaryColumn((String)columnName), DateTimeUtils.toInt96((LocalTime)localTime), subType);
        }
        LocalDateTime localDateTime = value.getTimestamp().toLocalDateTime();
        return ParquetFilters.buildComparisonOperator(FilterApi.binaryColumn((String)columnName), DateTimeUtils.toInt96((LocalDateTime)localDateTime), subType);
    }

    static <T extends Comparable<T>, C extends Operators.Column<T>> FilterPredicate buildComparisonOperator(C column, T value, SQLComparison.SubType subType) {
        switch (subType) {
            case LESS: {
                return FilterApi.lt(column, value);
            }
            case LESSEQUAL: {
                return FilterApi.ltEq(column, value);
            }
            case EQUAL: {
                return FilterApi.eq(column, value);
            }
            case NOTEQUAL: {
                return FilterApi.notEq(column, value);
            }
            case GREATEREQUAL: {
                return FilterApi.gtEq(column, value);
            }
            case GREATER: {
                return FilterApi.gt(column, value);
            }
        }
        throw new UnsupportedOperationException();
    }
}

