/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.olapengine.IPageStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.io.TempFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedList;

public class DirectTemporaryFileStorage
implements IPageStorage,
IReleasable {
    static final int PAGE_SIZE = 1024;
    private int pageSize;
    private FileChannel channel;
    private File file;
    private int bufferCount;
    LinkedList<ByteBuffer> free = new LinkedList();
    private int acquired;
    private int stored;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public DirectTemporaryFileStorage() {
        this(1024);
    }

    public DirectTemporaryFileStorage(int thePageSize) {
        this.pageSize = thePageSize;
        this.acquired = 0;
        this.stored = 0;
    }

    @Override
    public ByteBuffer acquire() {
        ByteBuffer buffer = this.free.isEmpty() ? ByteBuffer.allocate(this.pageSize) : this.free.remove();
        buffer.clear();
        ++this.acquired;
        return buffer;
    }

    @Override
    public long store(ByteBuffer buffer) throws IOException {
        if (this.channel == null) {
            this.openTemporaryFile();
        }
        long position = this.channel.position();
        buffer.flip();
        this.channel.write(buffer);
        buffer.clear();
        this.free.add(buffer);
        ++this.bufferCount;
        ++this.stored;
        return position;
    }

    @Override
    public ByteBuffer retrieve(long position) throws IOException {
        if (this.bufferCount == 0) {
            throw new IOException("The storage is empty.");
        }
        ByteBuffer buffer = this.free.isEmpty() ? ByteBuffer.allocate(this.pageSize) : this.free.remove();
        buffer.clear();
        this.channel.read(buffer, position);
        buffer.flip();
        --this.bufferCount;
        if (this.bufferCount == 0) {
            this.channel.position(0L);
        }
        return buffer;
    }

    @Override
    public void free(ByteBuffer buffer) {
        this.free.add(buffer);
    }

    @Override
    public void release() {
        if (this.channel != null) {
            try {
                this.channel.close();
                this.file.delete();
                this.channel = null;
            }
            catch (IOException e) {
                mErrorLogger.log(e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getPosition() {
        try {
            return this.channel.position();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private void openTemporaryFile() throws IOException {
        this.file = TempFileUtil.createTempFile(this.getClass().getSimpleName());
        RandomAccessFile ra = new RandomAccessFile(this.file, "rw");
        this.channel = ra.getChannel();
    }

    public int getAcquired() {
        return this.acquired;
    }

    public int getStored() {
        return this.stored;
    }

    public int getCurrentBufferCount() {
        return this.bufferCount;
    }
}

