/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.runtree.IMemoryAllocator;

public class MemoryAllocator {
    public static final long MEMORY_CHUNK_SIZE = 0x200000L;
    private static final long MASK = -14680064L;
    private long memAvailable;
    private long memUsed;
    private long maxMemUsed;
    private IMemoryAllocator globalMemoryAllocator;

    public MemoryAllocator(IMemoryAllocator theGlobalMemoryAllocator) {
        this.globalMemoryAllocator = theGlobalMemoryAllocator;
        this.memAvailable = 0L;
        this.memUsed = 0L;
    }

    public boolean allocateMemory(long numBytes) {
        long memRequired = this.memUsed + numBytes - this.memAvailable;
        if (memRequired > 0L) {
            if (memRequired < 0x200000L) {
                memRequired = 0x200000L;
            }
            if (!this.globalMemoryAllocator.allocateMemory(memRequired, false)) {
                return false;
            }
            this.memAvailable += memRequired;
        }
        this.memUsed += numBytes;
        if (this.memUsed > this.maxMemUsed) {
            this.maxMemUsed = this.memUsed;
        }
        return true;
    }

    public void releaseMemory(long numBytes) {
        this.memUsed -= numBytes;
        if (this.memUsed < 0L) {
            this.memUsed = 0L;
        }
        long memToRelease = 0L;
        if (this.memAvailable - this.memUsed >= 0x200000L) {
            long memRemaining = this.memAvailable - (this.memAvailable & 0xFFFFFFFFFF200000L);
            memToRelease += memRemaining;
            this.memAvailable -= memRemaining;
        }
        while (this.memAvailable - this.memUsed >= 0x200000L) {
            this.memAvailable -= 0x200000L;
            memToRelease += 0x200000L;
        }
        if (memToRelease > 0L) {
            this.globalMemoryAllocator.releaseMemory(memToRelease);
        }
    }

    public void releaseRemainingMemory() {
        if (this.memAvailable > 0L) {
            this.globalMemoryAllocator.releaseMemory(this.memAvailable);
            this.memAvailable = 0L;
            this.memUsed = 0L;
        }
    }

    public long getUsedMemory() {
        return this.memUsed;
    }

    public long getMaxUsedMemory() {
        return this.maxMemUsed;
    }
}

