/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.ICompressedColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IWindowProcessor;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;

public class WindowProcessorExtended
implements IWindowProcessor {
    private XSetFunction xFunction;
    private ISetFunctionState state;
    private int partitionByLength;
    private int atListLength;
    private boolean iterate;
    private int nRows;
    XDataContext context;
    ICompressedColumnStorage columnStorage;

    public WindowProcessorExtended(WindowDescriptor wd, XDataContext theContext, XSetFunction function) {
        this.xFunction = function;
        this.partitionByLength = wd.getPartitionByLength();
        this.atListLength = wd.getAtListLength();
        this.context = theContext;
        this.state = this.xFunction.initialize(this.context);
        this.nRows = 0;
        this.iterate = true;
    }

    @Override
    public void iterate() {
        if (this.iterate) {
            this.xFunction.iterate(this.context, this.state);
            if (this.atListLength > 0) {
                this.iterate = false;
            }
        }
        ++this.nRows;
    }

    @Override
    public void processBreak(int breakpointColumn) {
        if (this.atListLength > 0 && breakpointColumn < this.atListLength) {
            this.iterate = true;
        }
        if (breakpointColumn < this.partitionByLength) {
            IValue theValue = this.xFunction.getDataType().createValue(this.context.getLocalCollator());
            this.xFunction.getResult(this.context, this.state, theValue);
            this.columnStorage.store(theValue, this.nRows);
            this.xFunction.terminate(this.context, this.state);
            this.state = this.xFunction.initialize(this.context);
            this.nRows = 0;
        }
    }

    @Override
    public IColumnStorage createColumnStorage(IColumnStorageFactory csf) {
        if (this.columnStorage == null) {
            this.columnStorage = csf.createCompressedColumnStorage();
        }
        return this.columnStorage;
    }
}

