/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.runtree.IMemoryAllocator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import java.util.ArrayList;
import java.util.Collections;

public class SortEngine {
    private FileBasedPersistedResultSet sharedBucket;
    private IRowsetInfo rowsetInfo;
    private XDataContext context;
    private RowComparator comparator;
    private boolean noDupFlag;
    private IRow lastRow;
    private IMemoryAllocator memManager;
    private MemoryMergeSet rowsInMemory = new MemoryMergeSet();
    private ArrayList<IMergeSet> mergeSets = new ArrayList();
    boolean frozen = false;
    private long sortTimeAccumulator = 0L;

    public SortEngine(XDataContext aContext, IRowsetInfo aRowsetInfo, RowComparator aRowComparator, boolean aNoDupFlag) {
        this.rowsetInfo = aRowsetInfo;
        this.context = aContext;
        this.comparator = aRowComparator;
        this.noDupFlag = aNoDupFlag;
        this.memManager = this.context.getMemoryManager();
    }

    public void write(IRow row) {
        if (!this.rowsInMemory.add(row)) {
            long before = System.currentTimeMillis();
            this.mergeSets.add(new PersistedMergeSet(this.rowsInMemory));
            this.sortTimeAccumulator += System.currentTimeMillis() - before;
            this.rowsInMemory.add(row);
        }
    }

    public IRow next() {
        IRow result;
        if (!this.frozen) {
            this.mergeSets.add(this.rowsInMemory);
            this.frozen = true;
        }
        long before = System.currentTimeMillis();
        do {
            result = this.nextRow();
        } while (this.noDupFlag && result != null && this.lastRow != null && this.comparator.compare(result, this.lastRow) == 0);
        if (this.noDupFlag && result != null) {
            this.lastRow = (IRow)result.copy();
        }
        this.sortTimeAccumulator += System.currentTimeMillis() - before;
        return result;
    }

    private IRow nextRow() {
        if (this.mergeSets.isEmpty()) {
            return null;
        }
        if (this.mergeSets.size() > 1) {
            Collections.sort(this.mergeSets);
        }
        IMergeSet mergeSet = this.mergeSets.get(0);
        IRow result = mergeSet.current();
        mergeSet.mark();
        if (mergeSet.isEmpty()) {
            mergeSet.release();
            this.mergeSets.remove(mergeSet);
        }
        return result;
    }

    public void release() {
        for (IMergeSet mergeSet : this.mergeSets) {
            mergeSet.release();
        }
        if (this.sharedBucket != null) {
            this.sharedBucket.release();
            this.sharedBucket = null;
        }
        this.rowsInMemory.release();
    }

    public long getSortTimeInMillis() {
        return this.sortTimeAccumulator;
    }

    private class PersistedMergeSet
    implements IMergeSet {
        private XTabularIterator iterator;
        private IRow currentRow;
        int numRows;
        long firstRowOffset = -1L;

        PersistedMergeSet(MemoryMergeSet rowset) {
            Collections.sort(rowset, SortEngine.this.comparator);
            if (SortEngine.this.sharedBucket == null) {
                SortEngine.this.sharedBucket = new FileBasedPersistedResultSet(SortEngine.this.rowsetInfo.getDataType(), SortEngine.this.context);
            }
            for (IRow memRow : rowset) {
                if (this.firstRowOffset < 0L) {
                    this.firstRowOffset = SortEngine.this.sharedBucket.write(memRow);
                    continue;
                }
                SortEngine.this.sharedBucket.write(memRow);
            }
            this.numRows = rowset.size();
            rowset.release();
        }

        @Override
        public int compareTo(Object o) {
            IMergeSet other = (IMergeSet)o;
            return SortEngine.this.comparator.compare(this.current(), other.current());
        }

        private IRow next() {
            if (this.numRows-- > 0) {
                if (this.iterator == null) {
                    this.iterator = SortEngine.this.sharedBucket.getIterator(this.firstRowOffset);
                }
                this.currentRow = (IRow)this.iterator.next();
            } else {
                this.currentRow = null;
            }
            return this.currentRow;
        }

        @Override
        public IRow current() {
            if (this.iterator == null || this.currentRow == null) {
                this.next();
            }
            return this.currentRow;
        }

        @Override
        public void release() {
            if (this.iterator != null) {
                this.iterator.release();
                this.iterator = null;
            }
            this.currentRow = null;
        }

        @Override
        public boolean isEmpty() {
            return this.numRows == 0;
        }

        @Override
        public void mark() {
            this.currentRow = null;
        }
    }

    private class MemoryMergeSet
    extends ArrayList<IRow>
    implements IMergeSet {
        private static final long serialVersionUID = -6446371798815874916L;
        private static final int MIN_MEMORY_ALLOCATION = 256000;
        private boolean isSorted = false;
        long sizeOf = 0L;
        int currentRow = 0;

        private MemoryMergeSet() {
        }

        @Override
        public boolean add(IRow row) {
            int rowSize = row.sizeOf();
            if (SortEngine.this.memManager.allocateMemory(rowSize, this.sizeOf < 256000L)) {
                super.add(row);
                this.sizeOf += (long)rowSize;
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(Object o) {
            IMergeSet other = (IMergeSet)o;
            return SortEngine.this.comparator.compare(this.current(), other.current());
        }

        private IRow next() {
            if (this.currentRow == this.size()) {
                return null;
            }
            IRow row = (IRow)this.get(this.currentRow);
            this.set(this.currentRow, null);
            int rowSize = row.sizeOf();
            this.sizeOf -= (long)rowSize;
            SortEngine.this.memManager.releaseMemory(rowSize);
            ++this.currentRow;
            return this.current();
        }

        @Override
        public IRow current() {
            if (this.currentRow == this.size()) {
                return null;
            }
            if (!this.isSorted) {
                Collections.sort(this, SortEngine.this.comparator);
                this.isSorted = true;
            }
            return (IRow)this.get(this.currentRow);
        }

        @Override
        public void release() {
            super.clear();
            this.trimToSize();
            SortEngine.this.memManager.releaseMemory(this.sizeOf);
            this.sizeOf = 0L;
            this.isSorted = false;
            this.currentRow = 0;
        }

        @Override
        public boolean isEmpty() {
            return this.currentRow == this.size();
        }

        @Override
        public void mark() {
            this.next();
        }
    }

    private static interface IMergeSet
    extends Comparable<Object> {
        public IRow current();

        public void release();

        public boolean isEmpty();

        public void mark();
    }
}

