/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.VectorizedHashKeysSet;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.HashSet;

public class VectorDuplicateEliminator
extends XVectorTabularIterator {
    private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
    private static final int INITIAL_CAPACITY = 1000;
    private HashSet<VectorizedHashKeysSet> hashSet;
    private long memory = 0L;
    private XTabularIterator tabIt = null;
    private IRowsetInfo iResultSetInfo = null;
    private VectorizedHashKeysSet inputRowKeys = null;
    private int[] columnIndices;
    private XVectorContext vContext;

    public VectorDuplicateEliminator(XDataContext context, XTabularIterator theInputIterator, IRowsetInfo theIResultSetInfo, XVectorContext vc) {
        super(context, new Integer(-1), theIResultSetInfo);
        this.tabIt = theInputIterator;
        this.iResultSetInfo = theIResultSetInfo;
        this.hashSet = new HashSet(1000);
        this.columnIndices = new int[this.iResultSetInfo.getNumColumns()];
        for (int i = 0; i < this.columnIndices.length; ++i) {
            this.columnIndices[i] = i;
        }
        this.inputRowKeys = new VectorizedHashKeysSet(this.columnIndices, true, false);
        this.vContext = vc;
    }

    @Override
    public Object nextBatch() {
        boolean forced;
        boolean memoryAllocated = false;
        XVectorRowBatch inputBatch = null;
        try {
            inputBatch = (XVectorRowBatch)this.tabIt.nextBatch();
        }
        catch (OperationCanceledException e) {
            this.release();
            throw e;
        }
        if (inputBatch.eod) {
            this.tabIt.release();
            this.tabIt = null;
            this.batch = inputBatch;
            return inputBatch;
        }
        this.batch = inputBatch.copy();
        long memRequired = this.batch.sizeOf();
        boolean bl = forced = this.hashSet.size() == 0;
        if (this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
            this.memory += memRequired;
            memoryAllocated = true;
        }
        int j = 0;
        for (int i = 0; i < this.batch.size; ++i) {
            int index = i;
            if (this.batch.selectedInUse) {
                index = this.batch.selected[i];
            }
            this.inputRowKeys.set(this.batch, index);
            boolean exists = this.hashSet.contains(this.inputRowKeys);
            if (exists) continue;
            if (memoryAllocated) {
                this.hashSet.add(this.inputRowKeys.copy());
                this.batch.selected[j] = index;
                ++j;
                continue;
            }
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
            Runtime rt = Runtime.getRuntime();
            logger.log(String.format("Duplicate eliminator - hash set is full, creating a scanner. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
            this.makeScan();
            return this.nextBatch();
        }
        this.batch.size = j;
        this.batch.selectedInUse = true;
        return this.batch;
    }

    private void makeScan() {
        FileBasedPersistedResultSet scan = new FileBasedPersistedResultSet(this.iResultSetInfo.getDataType(), this.context);
        do {
            int j = 0;
            for (int i = 0; i < this.batch.size; ++i) {
                int index = i;
                if (this.batch.selectedInUse) {
                    index = this.batch.selected[i];
                }
                this.inputRowKeys.set(this.batch, index);
                boolean exists = this.hashSet.contains(this.inputRowKeys);
                if (exists) continue;
                this.batch.selected[j] = index;
                ++j;
            }
            this.batch.size = j;
            this.batch.selectedInUse = true;
            scan.write(this.batch);
            try {
                this.batch = (XVectorRowBatch)this.tabIt.nextBatch();
            }
            catch (OperationCanceledException e) {
                this.release();
                throw e;
            }
        } while (!this.batch.eod);
        scan.write(this.batch);
        this.tabIt.release();
        this.tabIt = scan.getVectorizedIterator(this.iResultSetInfo, this.vContext);
        this.hashSet.clear();
        if (this.memory > 0L) {
            this.context.getMemoryManager().releaseMemory(this.memory);
            this.memory = 0L;
        }
    }

    @Override
    public long getIndex() {
        return -1L;
    }

    @Override
    public void release() {
        if (this.tabIt != null) {
            this.tabIt.release();
            this.tabIt = null;
        }
        this.hashSet = null;
        if (this.memory > 0L) {
            this.context.getMemoryManager().releaseMemory(this.memory);
            this.memory = 0L;
        }
        super.release();
    }
}

