/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.runtree.IMemoryAllocator;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class VectorSortEngine {
    private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
    private FileBasedPersistedResultSet diskStorage;
    private XDataContext context;
    private RowComparator comparator;
    private OrderBy[] sorts;
    private boolean noDupFlag;
    private int lastRow;
    private XVectorRowBatch lastBatch;
    private IMemoryAllocator memManager;
    private MemoryMergeSet rowsInMemory;
    private ArrayList<IBatchMergeSet> mergeSets = new ArrayList();
    private boolean frozen = false;
    private long sortTimeAccumulator = 0L;
    private int sortedVectorPosition = -1;
    private XVectorRowBatch output;
    private IRowsetInfo rowsetInfo;
    private XVectorContext vContext;

    public VectorSortEngine(XDataContext aContext, IRowsetInfo aRowsetInfo, XVectorContext aVContext, RowComparator aRowComparator, boolean aNoDupFlag) {
        this.context = aContext;
        this.comparator = aRowComparator;
        this.noDupFlag = aNoDupFlag;
        this.memManager = this.context.getMemoryManager();
        this.lastRow = -1;
        this.sorts = this.comparator.getSorts();
        OrderBy orderBy = this.sorts[0];
        this.sortedVectorPosition = orderBy.getPosition();
        this.vContext = aVContext;
        this.rowsetInfo = aRowsetInfo;
    }

    public void writeBatch(XVectorRowBatch batch) {
        if (this.rowsInMemory == null) {
            this.rowsInMemory = new MemoryMergeSet(batch);
        } else if (!this.rowsInMemory.addBatch(batch)) {
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
            Runtime rt = Runtime.getRuntime();
            logger.log(String.format("Vector Sort Engine - writing merge set to disk. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
            long before = System.currentTimeMillis();
            this.mergeSets.add(new PersistedMergeSet(this.rowsInMemory));
            this.sortTimeAccumulator += System.currentTimeMillis() - before;
            this.rowsInMemory = new MemoryMergeSet(batch);
        }
    }

    public XVectorRowBatch nextBatch() {
        long before = System.currentTimeMillis();
        if (!this.frozen) {
            this.frozen = true;
            if (this.rowsInMemory != null) {
                this.mergeSets.add(this.rowsInMemory);
            }
            this.output = XVectorRowBatchUtil.createRowBatch(this.vContext, this.rowsetInfo, this.context.getLocalCollator());
        } else {
            this.output.reset();
            for (int i = 0; i < this.output.columns.length; ++i) {
                this.output.columns[i].isRepeating = true;
            }
        }
        XVectorRowBatch batch = this.output;
        while (batch.size < batch.maxBatchSize && !this.mergeSets.isEmpty()) {
            this.addNextRowToBatch(batch);
        }
        batch.columns[this.sortedVectorPosition].isSorted = true;
        if (this.mergeSets.isEmpty() && batch.size == 0) {
            batch.eod = true;
        }
        this.sortTimeAccumulator += System.currentTimeMillis() - before;
        return this.output;
    }

    private void addNextRowToBatch(XVectorRowBatch outputBatch) {
        XVectorRowBatch currentBatch;
        int row;
        do {
            if (this.mergeSets.isEmpty()) {
                row = -1;
                return;
            }
            if (this.mergeSets.size() > 1) {
                Collections.sort(this.mergeSets);
            }
            IBatchMergeSet mergeSet = this.mergeSets.get(0);
            row = mergeSet.current();
            currentBatch = mergeSet.getBatch();
            mergeSet.mark();
            if (!mergeSet.isEmpty()) continue;
            mergeSet.release();
            this.mergeSets.remove(mergeSet);
        } while (this.noDupFlag && row != -1 && this.lastRow != -1 && this.vectorValueCompare(row, currentBatch, this.lastRow, this.lastBatch) == 0);
        if (this.noDupFlag && row != -1) {
            this.lastRow = row;
            this.lastBatch = currentBatch;
        }
        XVectorRowBatchUtil.copyRow(row, currentBatch, outputBatch.size, outputBatch, true);
        ++outputBatch.size;
    }

    public void release() {
        for (IBatchMergeSet mergeSet : this.mergeSets) {
            mergeSet.release();
        }
        if (this.diskStorage != null) {
            this.diskStorage.release();
            this.diskStorage = null;
        }
        if (this.rowsInMemory != null) {
            this.rowsInMemory.release();
        }
    }

    public long getSortTimeInMillis() {
        return this.sortTimeAccumulator;
    }

    private int vectorValueCompare(int index1, XVectorRowBatch batch1, int index2, XVectorRowBatch batch2) {
        int result = 0;
        for (int i = 0; i < this.sorts.length && result == 0; ++i) {
            OrderBy orderBy = this.sorts[i];
            int position = orderBy.getPosition();
            ColumnVector vector1 = batch1.columns[position];
            ColumnVector vector2 = batch2.columns[position];
            int i1 = index1;
            int i2 = index2;
            if (vector1.isRepeating) {
                i1 = 0;
            }
            if (vector2.isRepeating) {
                i2 = 0;
            }
            if (vector1.isNull[i1] && vector2.isNull[i2]) {
                result = 0;
                continue;
            }
            if (vector1.isNull[i1]) {
                if (orderBy.getNullOrdering() == SQLSortKey.NullOrdering.NULLS_FIRST) {
                    result = -1;
                    continue;
                }
                result = 1;
                continue;
            }
            if (vector2.isNull[i2]) {
                if (orderBy.getNullOrdering() == SQLSortKey.NullOrdering.NULLS_FIRST) {
                    result = 1;
                    continue;
                }
                result = -1;
                continue;
            }
            result = vector1.compare(i1, vector2, i2);
            if (orderBy.isAscending()) continue;
            result *= -1;
        }
        return result;
    }

    private class MemoryMergeSet
    implements IBatchMergeSet {
        private boolean isSorted = false;
        private int currentRow = 0;
        private int currentBatch = -1;
        private int rowBatchSize;
        private ArrayList<XVectorRowBatch> batches;
        private ArrayList<Integer> sortedIndices = new ArrayList();
        private long memorySize;

        MemoryMergeSet(XVectorRowBatch inputBatch) {
            this.batches = new ArrayList();
            this.rowBatchSize = inputBatch.maxBatchSize;
            this.memorySize = 0L;
            this.addBatch(inputBatch);
        }

        public boolean addBatch(XVectorRowBatch rowBatch) {
            int max = (this.batches.size() + 1) * this.rowBatchSize;
            int minBatchesInMergeSet = 3;
            boolean forceAllocateMemory = this.batches.size() < 3;
            long memoryRequired = rowBatch.sizeOf();
            if (max > 0 && VectorSortEngine.this.memManager.allocateMemory(memoryRequired += (long)(ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.INTEGER) * rowBatch.size), forceAllocateMemory)) {
                this.memorySize += memoryRequired;
                int offset = this.batches.size() * this.rowBatchSize;
                if (rowBatch.selectedInUse) {
                    for (int i = 0; i < rowBatch.size; ++i) {
                        this.sortedIndices.add(rowBatch.selected[i] + offset);
                    }
                } else {
                    for (int i = 0; i < rowBatch.size; ++i) {
                        this.sortedIndices.add(Integer.valueOf(i) + offset);
                    }
                }
                this.batches.add(rowBatch.copy());
                return true;
            }
            return false;
        }

        @Override
        public int compareTo(IBatchMergeSet other) {
            return VectorSortEngine.this.vectorValueCompare(this.current(), this.getBatch(), other.current(), other.getBatch());
        }

        private int next() {
            if (this.currentRow == this.sortedIndices.size()) {
                return -1;
            }
            ++this.currentRow;
            return this.current();
        }

        @Override
        public int current() {
            if (this.currentRow == this.sortedIndices.size()) {
                return -1;
            }
            if (!this.isSorted) {
                Comparator<Integer> indexComparator = new Comparator<Integer>(){

                    @Override
                    public int compare(Integer arg0, Integer arg1) {
                        int i1 = arg0;
                        int i2 = arg1;
                        int index1 = i1 % MemoryMergeSet.this.rowBatchSize;
                        int index2 = i2 % MemoryMergeSet.this.rowBatchSize;
                        int batch1 = i1 / MemoryMergeSet.this.rowBatchSize;
                        int batch2 = i2 / MemoryMergeSet.this.rowBatchSize;
                        return VectorSortEngine.this.vectorValueCompare(index1, (XVectorRowBatch)MemoryMergeSet.this.batches.get(batch1), index2, (XVectorRowBatch)MemoryMergeSet.this.batches.get(batch2));
                    }
                };
                Collections.sort(this.sortedIndices, indexComparator);
                this.isSorted = true;
            }
            int index = this.sortedIndices.get(this.currentRow);
            this.currentBatch = index / this.rowBatchSize;
            return index % this.rowBatchSize;
        }

        @Override
        public void release() {
            this.batches = null;
            this.sortedIndices = null;
            VectorSortEngine.this.memManager.releaseMemory(this.memorySize);
        }

        @Override
        public boolean isEmpty() {
            return this.currentRow == this.sortedIndices.size();
        }

        @Override
        public void mark() {
            this.next();
        }

        @Override
        public XVectorRowBatch getBatch() {
            return this.batches.get(this.currentBatch);
        }
    }

    private class PersistedMergeSet
    implements IBatchMergeSet {
        ArrayList<Long> batchOffsets = new ArrayList();
        XVectorRowBatch currentBatch;
        int currentBatchIndex = -1;
        int currentRow = -1;
        XVectorTabularIterator it;

        PersistedMergeSet(MemoryMergeSet mergeSet) {
            mergeSet.current();
            XVectorRowBatch tmp = null;
            if (VectorSortEngine.this.diskStorage == null) {
                VectorSortEngine.this.diskStorage = new FileBasedPersistedResultSet(null, VectorSortEngine.this.context);
            }
            tmp = XVectorRowBatchUtil.copyRowBatchStructure(mergeSet.getBatch(), mergeSet.getBatch().maxBatchSize);
            while (!mergeSet.isEmpty()) {
                while (tmp.size < tmp.maxBatchSize && !mergeSet.isEmpty()) {
                    this.transferNextRow(tmp, mergeSet);
                }
                this.batchOffsets.add(VectorSortEngine.this.diskStorage.write(tmp));
                tmp.reset();
            }
            this.currentBatch = XVectorRowBatchUtil.copyRowBatchStructure(mergeSet.getBatch(), mergeSet.getBatch().maxBatchSize);
            mergeSet.release();
        }

        private void transferNextRow(XVectorRowBatch outputBatch, MemoryMergeSet mergeSet) {
            if (mergeSet.isEmpty()) {
                return;
            }
            int row = mergeSet.current();
            XVectorRowBatch batch = mergeSet.getBatch();
            mergeSet.mark();
            XVectorRowBatchUtil.copyRow(row, batch, outputBatch.size, outputBatch, true);
            ++outputBatch.size;
        }

        @Override
        public int compareTo(IBatchMergeSet other) {
            return VectorSortEngine.this.vectorValueCompare(this.current(), this.getBatch(), other.current(), other.getBatch());
        }

        private int next() {
            if (this.it == null) {
                this.it = VectorSortEngine.this.diskStorage.getVectorizedIterator(this.batchOffsets.get(0), VectorSortEngine.this.rowsetInfo, VectorSortEngine.this.vContext, false);
            }
            ++this.currentRow;
            if (this.currentBatch == null || this.currentRow >= this.currentBatch.size) {
                ++this.currentBatchIndex;
                if (this.currentBatchIndex >= this.batchOffsets.size()) {
                    return -1;
                }
                this.currentBatch = (XVectorRowBatch)this.it.nextBatch();
                this.currentRow = 0;
            }
            return this.current();
        }

        @Override
        public int current() {
            if (this.currentRow == -1) {
                this.next();
            }
            return this.currentRow;
        }

        @Override
        public XVectorRowBatch getBatch() {
            return this.currentBatch;
        }

        @Override
        public void release() {
            if (this.it != null) {
                this.it.release();
                this.it = null;
            }
        }

        @Override
        public boolean isEmpty() {
            return this.currentBatchIndex >= this.batchOffsets.size();
        }

        @Override
        public void mark() {
            this.next();
        }
    }

    private static interface IBatchMergeSet
    extends Comparable<IBatchMergeSet> {
        public int current();

        public XVectorRowBatch getBatch();

        public void release();

        public boolean isEmpty();

        public void mark();
    }
}

