/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.util;

import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;

public class VectorizedHashKeysSet {
    private XVectorRowBatch batch;
    private int index;
    private int[] columnIndices;
    private boolean useFastHash;
    private boolean ignoreHashCode = false;

    public VectorizedHashKeysSet(int[] columns, boolean fastHash, boolean ignoreHash) {
        this.columnIndices = columns;
        this.useFastHash = fastHash;
        this.ignoreHashCode = ignoreHash;
    }

    public VectorizedHashKeysSet(XVectorRowBatch rowBatch, int rowBatchIndex, int[] columns, boolean fastHash, boolean ignoreHash) {
        this.batch = rowBatch;
        this.index = rowBatchIndex;
        this.columnIndices = columns;
        this.useFastHash = fastHash;
        this.ignoreHashCode = ignoreHash;
    }

    public VectorizedHashKeysSet copy() {
        return new VectorizedHashKeysSet(this.batch, this.index, this.columnIndices, this.useFastHash, this.ignoreHashCode);
    }

    public void set(XVectorRowBatch rowBatch, int rowBatchIndex) {
        this.batch = rowBatch;
        this.index = rowBatchIndex;
    }

    public int hashCode() {
        if (this.ignoreHashCode) {
            return 0;
        }
        return this.batch.hashCode(this.index, this.columnIndices, this.useFastHash);
    }

    public int sizeOf() {
        int size = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE);
        return size += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINTARRAY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VectorizedHashKeysSet)) {
            return false;
        }
        VectorizedHashKeysSet other = (VectorizedHashKeysSet)obj;
        try {
            return this.batch.equalsWithImplicitCast(other.batch, this.index, other.index, this.columnIndices, other.columnIndices);
        }
        catch (XQERuntimeException e) {
            return false;
        }
    }

    public XVectorRowBatch getRowBatch() {
        return this.batch;
    }

    public int getRowBatchIndex() {
        return this.index;
    }
}

