/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class BytesColumnVector
extends ColumnVector {
    public static final long NULL_VALUE = 1L;
    public byte[][] vector;
    private int nBytes;

    public BytesColumnVector(IDataType dType, boolean isSorted, int vectorSize) {
        super(dType, isSorted, vectorSize);
        this.vector = new byte[vectorSize][];
        this.nBytes = dType.getMaxLength();
        for (int i = 0; i < this.nBytes; ++i) {
            this.vector[i] = new byte[this.nBytes];
        }
        this.noNulls = true;
    }

    @Override
    public void assign(int index, Object value) {
        if (value == null) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        if (value instanceof ByteBuffer) {
            this.set(index, (ByteBuffer)value);
        } else {
            this.set(index, (byte[])value);
        }
    }

    public void set(int index, byte[] value) {
        System.arraycopy(value, 0, this.vector[index], 0, this.nBytes);
    }

    public void set(int index, ByteBuffer value) {
        value.get(this.vector[index], 0, Math.min(value.remaining(), this.nBytes));
    }

    @Override
    public void complete(int nValues) {
        if (!this.isSorted) {
            return;
        }
        this.isRepeating = this.isNull[0] || this.isNull[nValues - 1] ? this.isNull[0] && this.isNull[nValues - 1] : this.compare(this.vector[0], this.vector[nValues - 1]) == 0;
    }

    @Override
    public void copyFrom(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        }
        this.vector[dstIndex] = ((BytesColumnVector)srcVector).vector[srcIndex];
    }

    @Override
    public void assign(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
            return;
        }
        System.arraycopy(((BytesColumnVector)srcVector).vector[srcIndex], 0, this.vector[dstIndex], 0, this.nBytes);
    }

    @Override
    public void vectorCopyImpl(ColumnVector srcVector, int size) {
        byte[][] inputVector = ((BytesColumnVector)srcVector).vector;
        if (this.isRepeating) {
            this.vector[0] = inputVector[0];
        } else {
            System.arraycopy(inputVector, 0, this.vector, 0, size);
        }
    }

    @Override
    public Object getObject(int index) {
        return this.vector[index];
    }

    @Override
    public byte[] getBytes(int index) {
        return this.vector[index];
    }

    @Override
    public boolean equals(int index1, int index2) {
        if (this.isRepeating) {
            return true;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || this.isNull[index2]) {
            return false;
        }
        return this.compare(this.vector[index1], this.vector[index2]) == 0;
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        BytesColumnVector otherVector = (BytesColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || otherVector.isNull[index2]) {
            return false;
        }
        return this.compare(this.vector[index1], otherVector.vector[index2]) == 0;
    }

    @Override
    public boolean equals(int i, Object value) {
        return false;
    }

    @Override
    public int compare(int index1, int index2) {
        if (this.isRepeating) {
            return 0;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (this.isNull[index2]) {
            return 1;
        }
        return this.compare(this.vector[index1], this.vector[index2]);
    }

    @Override
    public int compare(int i1, ColumnVector v2, int i2) {
        BytesColumnVector otherVector = (BytesColumnVector)v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (otherVector.isNull[index2]) {
            return 1;
        }
        return this.compare(this.vector[index1], otherVector.vector[index2]);
    }

    @Override
    public int compareWithImplicitCast(int i1, ColumnVector v2, int i2) {
        throw new UnsupportedOperationException();
    }

    private int compare(byte[] arr1, byte[] arr2) {
        for (int i = 0; i < this.nBytes; ++i) {
            if (arr1[i] > arr2[i]) {
                return 1;
            }
            if (arr1[i] >= arr2[i]) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public boolean copyValue(int sIndex, int tIndex, ColumnVector targetVector, boolean addValue) {
        int sourceIndex = sIndex;
        int targetIndex = tIndex;
        BytesColumnVector target = (BytesColumnVector)targetVector;
        if (this.isRepeating) {
            sourceIndex = 0;
        }
        if (targetVector.isRepeating) {
            if (!this.isNull[sourceIndex] && !target.isNull[0] && this.compare(this.vector[sourceIndex], target.vector[0]) == 0) {
                return true;
            }
            if (this.isNull[sourceIndex] && target.isNull[0]) {
                return true;
            }
            if (targetIndex > 0) {
                if (addValue) {
                    targetVector.materializeRepeatingValues(targetIndex - 1);
                } else {
                    targetVector.materializeRepeatingValues(target.vector.length - 1);
                }
            }
        }
        targetVector.isRepeating = false;
        if (this.vector[sourceIndex] != null) {
            System.arraycopy(this.vector[sourceIndex], 0, target.vector[targetIndex], 0, this.nBytes);
        }
        target.isNull[targetIndex] = this.isNull[sourceIndex];
        if (target.isNull[targetIndex]) {
            target.noNulls = false;
        }
        return true;
    }

    @Override
    protected boolean materializeRepeatingValues(int size) {
        if (this.isRepeating) {
            for (int i = 1; i <= size; ++i) {
                System.arraycopy(this.vector[0], 0, this.vector[i], 0, this.nBytes);
                this.isNull[i] = this.isNull[0];
            }
            return true;
        }
        return false;
    }

    @Override
    public ColumnVector copy(int size) {
        BytesColumnVector copy = new BytesColumnVector(this.dataType, this.isSorted, this.vector.length);
        copy.isRepeating = this.isRepeating;
        copy.noNulls = this.noNulls;
        if (this.isRepeating) {
            if (this.vector[0] != null) {
                System.arraycopy(this.vector[0], 0, copy.vector[0], 0, this.nBytes);
            }
            copy.isNull[0] = this.isNull[0];
        } else if (this.noNulls) {
            for (int i = 0; i < size; ++i) {
                System.arraycopy(this.vector[i], 0, copy.vector[i], 0, this.nBytes);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                copy.isNull[i] = this.isNull[i];
                if (this.isNull[i]) continue;
                System.arraycopy(this.vector[i], 0, copy.vector[i], 0, this.nBytes);
            }
        }
        return copy;
    }

    @Override
    public void expandImpl(int size) {
        byte[][] newVector = new byte[this.vector.length + size][];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block11: {
            block10: {
                super.encode(context, oStream, size, selected);
                if (!this.isRepeating) break block10;
                if (this.isNull[0]) break block11;
                oStream.write(this.vector[0], 0, this.nBytes);
                break block11;
            }
            if (selected != null) {
                if (this.noNulls) {
                    for (int i = 0; i < size; ++i) {
                        int j = selected[i];
                        oStream.write(this.vector[j], 0, this.nBytes);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        int j = selected[i];
                        if (this.isNull[j]) continue;
                        oStream.write(this.vector[j], 0, this.nBytes);
                    }
                }
            } else if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    oStream.write(this.vector[i], 0, this.nBytes);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    oStream.write(this.vector[i], 0, this.nBytes);
                }
            }
        }
    }

    @Override
    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size;
        block5: {
            block4: {
                size = super.decode(context, iStream);
                if (!this.isRepeating) break block4;
                if (this.isNull[0]) break block5;
                iStream.readFully(this.vector[0], 0, this.nBytes);
                break block5;
            }
            if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    iStream.readFully(this.vector[i], 0, this.nBytes);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    iStream.readFully(this.vector[i], 0, this.nBytes);
                }
            }
        }
        return size;
    }

    @Override
    public int sizeOf() {
        int result = super.sizeOf();
        result = (int)((long)result + ValueSizeInfo.byteArraySize(this.vector[0]) * (long)this.vector.length);
        return result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT);
    }

    @Override
    public int hashCode(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.isNull[index]) {
            return Integer.MIN_VALUE;
        }
        return Arrays.hashCode(this.vector[index]);
    }

    @Override
    public void getValue(int index, Value value) {
        value.setFormatId(this.formatId);
        if (this.isNull[index]) {
            value.setNull();
        } else {
            value.set(this.vector[index]);
        }
    }

    @Override
    public void valueToXMLStringImpl(XMLWriter writer, int i) {
    }
}

