/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class DecimalColumnVector
extends ColumnVector {
    public static final long NULL_VALUE = 1L;
    public BigDecimal[] vector;
    public int precision;
    public int scale;

    public DecimalColumnVector(IDataType dType, boolean isSorted, int vectorSize) {
        super(dType, isSorted, vectorSize);
        this.precision = dType.getPrecision();
        this.scale = dType.getScale();
        this.vector = new BigDecimal[vectorSize];
        for (int i = 0; i < vectorSize; ++i) {
            this.vector[i] = BigDecimal.ZERO;
        }
        this.noNulls = true;
    }

    @Override
    public void assign(int index, IValue value) {
        if (value.isNull()) {
            this.isNull[index] = true;
            this.noNulls = false;
        } else {
            this.vector[index] = this.precision != 0 ? ((Value)value).getBigDecimal(this.precision, this.scale) : ((Value)value).getBigDecimal();
        }
    }

    @Override
    public void assign(int index, Object value) {
        if (value == null) {
            this.isNull[index] = true;
            this.noNulls = false;
            return;
        }
        if (value instanceof String) {
            BigDecimal bd;
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
            df.setParseBigDecimal(true);
            String iValue = ((String)value).trim();
            if (iValue.charAt(0) == '+') {
                iValue = iValue.substring(1);
            }
            try {
                bd = (BigDecimal)df.parse(iValue);
            }
            catch (Exception e) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", iValue, "decimal");
            }
            this.vector[index] = bd.setScale(this.scale, 1);
        } else {
            this.vector[index] = value instanceof Short || value instanceof Integer || value instanceof Long ? DecimalUtil.cast(BigDecimal.valueOf(((Number)value).longValue(), this.scale), this.dataType) : (value instanceof Float || value instanceof Double ? BigDecimal.valueOf(((Number)value).doubleValue()).setScale(this.scale, RoundingMode.HALF_DOWN) : (BigDecimal)value);
        }
    }

    public void fill(BigDecimal value) {
        this.noNulls = true;
        this.isRepeating = true;
        this.vector[0] = value;
    }

    public void copySelected(boolean selectedInUse, int[] selected, int size, DecimalColumnVector output) {
        int i;
        int j;
        output.noNulls = this.noNulls;
        output.isRepeating = false;
        if (this.isRepeating) {
            output.vector[0] = this.vector[0];
            output.isNull[0] = this.isNull[0];
            output.isRepeating = true;
            return;
        }
        if (selectedInUse) {
            for (j = 0; j < size; ++j) {
                i = selected[j];
                output.vector[i] = this.vector[i];
            }
        } else {
            System.arraycopy(this.vector, 0, output.vector, 0, size);
        }
        if (!this.noNulls) {
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = selected[j];
                    output.isNull[i] = this.isNull[i];
                }
            } else {
                System.arraycopy(this.isNull, 0, output.isNull, 0, size);
            }
        }
    }

    @Override
    public void complete(int nValues) {
        if (!this.isSorted) {
            return;
        }
        this.isRepeating = this.isNull[0] || this.isNull[nValues - 1] ? this.isNull[0] && this.isNull[nValues - 1] : this.vector[0].equals(this.vector[nValues - 1]);
    }

    @Override
    public void copyFrom(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        } else {
            this.isNull[dstIndex] = false;
        }
        this.vector[dstIndex] = this.precision != 0 ? srcVector.getBigDecimal(srcIndex, this.precision, this.scale) : srcVector.getBigDecimal(srcIndex);
    }

    @Override
    public void assign(int dstIndex, ColumnVector srcVector, int inSrcIndex) {
        int srcIndex = inSrcIndex;
        if (srcVector.isRepeating) {
            srcIndex = 0;
        }
        if (srcVector.isNull[srcIndex]) {
            this.isNull[dstIndex] = true;
            this.noNulls = false;
        } else {
            this.isNull[dstIndex] = false;
        }
        this.vector[dstIndex] = this.getBigDecimal(srcVector, srcIndex);
    }

    @Override
    public void vectorCopyImpl(ColumnVector srcVector, int size) {
        if (srcVector instanceof LongColumnVector) {
            long[] inputVector = ((LongColumnVector)srcVector).vector;
            if (this.isRepeating) {
                this.vector[0] = BigDecimal.valueOf(inputVector[0]);
            } else {
                for (int i = 0; i < size; ++i) {
                    this.vector[i] = BigDecimal.valueOf(inputVector[i]);
                }
            }
        } else {
            BigDecimal[] inputVector = ((DecimalColumnVector)srcVector).vector;
            if (this.isRepeating) {
                this.vector[0] = inputVector[0];
            } else {
                System.arraycopy(inputVector, 0, this.vector, 0, size);
            }
        }
    }

    @Override
    public Object getObject(int index) {
        return this.vector[index];
    }

    @Override
    public byte[] getBytes(int index) {
        return this.vector[index].unscaledValue().toByteArray();
    }

    @Override
    public long getLong(int index) {
        return this.vector[index].longValue();
    }

    @Override
    public double getDouble(int index) {
        return this.vector[index].doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.vector[index];
    }

    @Override
    public BigDecimal getBigDecimal(int index, int newPrecision, int newScale) {
        return DecimalUtil.cast(this.vector[index], newPrecision, newScale);
    }

    public void setNullDataValue(int index) {
        BigDecimal minimumNonZeroValue;
        this.vector[index] = minimumNonZeroValue = new BigDecimal(BigInteger.ONE, this.scale);
    }

    public void set(int index, BigDecimal value) {
        this.vector[index] = value;
    }

    public void set(int index, double value) {
        BigDecimal bd = new BigDecimal(Double.toString(value), new MathContext(this.precision, RoundingMode.HALF_DOWN));
        this.vector[index] = bd.setScale(this.scale, 5);
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public boolean equals(int index1, int index2) {
        if (this.isRepeating) {
            return true;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || this.isNull[index2]) {
            return false;
        }
        return this.vector[index1].equals(this.vector[index2]);
    }

    @Override
    public boolean equals(int i1, ColumnVector v2, int i2) {
        ColumnVector otherVector = v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return true;
        }
        if (this.isNull[index1] || otherVector.isNull[index2]) {
            return false;
        }
        return this.vector[index1].equals(this.getBigDecimal(otherVector, index2));
    }

    @Override
    public boolean equals(int i, Object value) {
        return this.vector[i].equals(value);
    }

    @Override
    public int compare(int index1, int index2) {
        if (this.isRepeating) {
            return 0;
        }
        if (this.isNull[index1] && this.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (this.isNull[index2]) {
            return 1;
        }
        return this.vector[index1].compareTo(this.vector[index2]);
    }

    @Override
    public int compare(int i1, ColumnVector v2, int i2) {
        ColumnVector otherVector = v2;
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && otherVector.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (otherVector.isNull[index2]) {
            return 1;
        }
        return this.vector[index1].compareTo(this.getBigDecimal(otherVector, index2));
    }

    @Override
    public int compareWithImplicitCast(int i1, ColumnVector v2, int i2) {
        int index1 = i1;
        int index2 = i2;
        if (this.isRepeating) {
            index1 = 0;
        }
        if (v2.isRepeating) {
            index2 = 0;
        }
        if (this.isNull[index1] && v2.isNull[index2]) {
            return 0;
        }
        if (this.isNull[index1]) {
            return -1;
        }
        if (v2.isNull[index2]) {
            return 1;
        }
        if (this.precision != 0) {
            return this.vector[index1].compareTo(v2.getBigDecimal(index2, this.precision, this.scale));
        }
        return this.vector[index1].compareTo(v2.getBigDecimal(index2));
    }

    @Override
    public boolean copyValue(int sIndex, int tIndex, ColumnVector targetVector, boolean addValue) {
        if (!(targetVector instanceof DecimalColumnVector)) {
            return false;
        }
        int sourceIndex = sIndex;
        int targetIndex = tIndex;
        DecimalColumnVector target = (DecimalColumnVector)targetVector;
        if (this.isRepeating) {
            sourceIndex = 0;
        }
        if (targetVector.isRepeating) {
            if (!this.isNull[sourceIndex] && !target.isNull[0] && this.vector[sourceIndex].equals(target.vector[0])) {
                return true;
            }
            if (this.isNull[sourceIndex] && target.isNull[0]) {
                return true;
            }
            if (targetIndex > 0) {
                if (addValue) {
                    targetVector.materializeRepeatingValues(targetIndex - 1);
                } else {
                    targetVector.materializeRepeatingValues(target.vector.length - 1);
                }
            }
        }
        targetVector.isRepeating = false;
        target.vector[targetIndex] = this.vector[sourceIndex];
        target.isNull[targetIndex] = this.isNull[sourceIndex];
        if (target.isNull[targetIndex]) {
            target.noNulls = false;
        }
        return true;
    }

    @Override
    protected boolean materializeRepeatingValues(int size) {
        if (this.isRepeating) {
            for (int i = 1; i <= size; ++i) {
                this.vector[i] = this.vector[0];
                this.isNull[i] = this.isNull[0];
            }
            return true;
        }
        return false;
    }

    @Override
    public ColumnVector copy(int size) {
        DecimalColumnVector copy = new DecimalColumnVector(this.dataType, this.isSorted, this.vector.length);
        copy.isRepeating = this.isRepeating;
        copy.noNulls = this.noNulls;
        if (this.isRepeating) {
            copy.vector[0] = this.vector[0];
            copy.isNull[0] = this.isNull[0];
        } else {
            for (int i = 0; i < this.vector.length; ++i) {
                copy.vector[i] = this.vector[i];
                copy.isNull[i] = this.isNull[i];
            }
        }
        return copy;
    }

    @Override
    public void expandImpl(int size) {
        BigDecimal[] newVector = new BigDecimal[this.vector.length + size];
        for (int i = 0; i < newVector.length; ++i) {
            newVector[i] = BigDecimal.ZERO;
        }
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        this.vector = newVector;
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream, int size, int[] selected) throws IOException {
        block11: {
            block10: {
                super.encode(context, oStream, size, selected);
                if (!this.isRepeating) break block10;
                if (this.isNull[0]) break block11;
                byte[] bytes = this.vector[0].unscaledValue().toByteArray();
                oStream.writeByte(this.vector[0].scale());
                oStream.writeByte(bytes.length);
                oStream.write(bytes);
                break block11;
            }
            if (selected != null) {
                if (this.noNulls) {
                    for (int i = 0; i < size; ++i) {
                        byte[] bytes = this.vector[selected[i]].unscaledValue().toByteArray();
                        oStream.writeByte(this.vector[selected[i]].scale());
                        oStream.writeByte(bytes.length);
                        oStream.write(bytes);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        if (this.isNull[selected[i]]) continue;
                        byte[] bytes = this.vector[selected[i]].unscaledValue().toByteArray();
                        oStream.writeByte(this.vector[selected[i]].scale());
                        oStream.writeByte(bytes.length);
                        oStream.write(bytes);
                    }
                }
            } else if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    byte[] bytes = this.vector[i].unscaledValue().toByteArray();
                    oStream.writeByte(this.vector[i].scale());
                    oStream.writeByte(bytes.length);
                    oStream.write(bytes);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    byte[] bytes = this.vector[i].unscaledValue().toByteArray();
                    oStream.writeByte(this.vector[i].scale());
                    oStream.writeByte(bytes.length);
                    oStream.write(bytes);
                }
            }
        }
    }

    @Override
    public int decode(XDataContext context, DataInput iStream) throws IOException {
        int size;
        block5: {
            block4: {
                size = super.decode(context, iStream);
                if (!this.isRepeating) break block4;
                if (this.isNull[0]) break block5;
                byte vscale = iStream.readByte();
                byte len = iStream.readByte();
                byte[] bytes = new byte[len];
                iStream.readFully(bytes);
                this.vector[0] = new BigDecimal(new BigInteger(bytes), vscale);
                break block5;
            }
            if (this.noNulls) {
                for (int i = 0; i < size; ++i) {
                    byte vscale = iStream.readByte();
                    byte len = iStream.readByte();
                    byte[] bytes = new byte[len];
                    iStream.readFully(bytes);
                    this.vector[i] = new BigDecimal(new BigInteger(bytes), vscale);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (this.isNull[i]) continue;
                    byte vscale = iStream.readByte();
                    byte len = iStream.readByte();
                    byte[] bytes = new byte[len];
                    iStream.readFully(bytes);
                    this.vector[i] = new BigDecimal(new BigInteger(bytes), vscale);
                }
            }
        }
        return size;
    }

    @Override
    public int sizeOf() {
        int result = super.sizeOf();
        result += ValueSizeInfo.getSizeOfBigDecimal(this.vector[0]) * this.vector.length;
        return result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * 2;
    }

    @Override
    public int hashCode(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.isNull[index]) {
            return Integer.MIN_VALUE;
        }
        return Double.hashCode(this.vector[index].doubleValue());
    }

    @Override
    public int fastHash(int i) {
        int index = i;
        if (this.isRepeating) {
            index = 0;
        }
        if (this.isNull[index]) {
            return Integer.MIN_VALUE;
        }
        return this.vector[index].hashCode();
    }

    @Override
    public void getValue(int index, Value value) {
        value.setFormatId(this.formatId);
        if (this.isNull[index]) {
            value.setNull();
        } else {
            value.set(this.vector[index]);
        }
    }

    @Override
    public void valueToXMLStringImpl(XMLWriter writer, int i) {
    }

    private BigDecimal getBigDecimal(ColumnVector srcVector, int srcIndex) {
        if (srcVector instanceof LongColumnVector) {
            return BigDecimal.valueOf(((LongColumnVector)srcVector).vector[srcIndex]);
        }
        return ((DecimalColumnVector)srcVector).vector[srcIndex];
    }
}

