/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DoubleColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class DecimalUtil {
    public static BigDecimal getDecimalValue(Number value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Double) {
            return BigDecimal.valueOf(value.doubleValue());
        }
        if (value instanceof Float) {
            return BigDecimal.valueOf(value.floatValue());
        }
        if (value instanceof Long) {
            return BigDecimal.valueOf(value.longValue());
        }
        if (value instanceof Integer) {
            return BigDecimal.valueOf(value.intValue());
        }
        return BigDecimal.valueOf(value.shortValue());
    }

    public static BigDecimal getDecimalValue(ColumnVector inVec, int idx) {
        BigDecimal result = null;
        result = inVec instanceof LongColumnVector ? BigDecimal.valueOf(((LongColumnVector)inVec).vector[idx]) : (inVec instanceof DoubleColumnVector ? BigDecimal.valueOf(((DoubleColumnVector)inVec).vector[idx]) : ((DecimalColumnVector)inVec).vector[idx]);
        return result;
    }

    public static BigDecimal cast(BigDecimal value, IDataType dataType) {
        return DecimalUtil.cast(value, dataType.getPrecision(), dataType.getScale());
    }

    public static BigDecimal cast(BigDecimal value, int newPrecision, int newScale) {
        if (newPrecision == 0 && newScale == 0) {
            return value;
        }
        int scale = value.scale();
        int precision = value.precision();
        if (precision != newPrecision || scale != newScale) {
            if (precision == newPrecision) {
                value = value.setScale(newScale, RoundingMode.HALF_DOWN);
            } else {
                value = new BigDecimal(value.unscaledValue(), scale, new MathContext(newPrecision));
                if (scale != newScale) {
                    value = value.setScale(newScale, RoundingMode.HALF_DOWN);
                }
            }
        }
        return value;
    }

    public static void addChecked(int i, BigDecimal left, BigDecimal right, DecimalColumnVector outputColVector) {
        try {
            outputColVector.set(i, left.add(right));
        }
        catch (ArithmeticException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, right.toString(), Integer.toString(left.precision()), Integer.toString(left.scale()));
        }
    }

    public static void subtractChecked(int i, BigDecimal left, BigDecimal right, DecimalColumnVector outputColVector) {
        try {
            outputColVector.set(i, left.subtract(right));
        }
        catch (ArithmeticException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, right.toString(), Integer.toString(left.precision()), Integer.toString(left.scale()));
        }
    }

    public static void multiplyChecked(int i, BigDecimal left, BigDecimal right, DecimalColumnVector outputColVector) {
        try {
            outputColVector.set(i, left.multiply(right));
        }
        catch (ArithmeticException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, right.toString(), Integer.toString(left.precision()), Integer.toString(left.scale()));
        }
    }

    public static void divideChecked(int i, BigDecimal left, BigDecimal right, DecimalColumnVector outputColVector) {
        try {
            outputColVector.set(i, left.divide(right, outputColVector.getScale(), RoundingMode.DOWN));
        }
        catch (ArithmeticException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, right.toString(), Integer.toString(left.precision()), Integer.toString(left.scale()));
        }
    }

    public static void moduloChecked(int i, BigDecimal left, BigDecimal right, DecimalColumnVector outputColVector) {
        try {
            outputColVector.set(i, left.remainder(right));
        }
        catch (ArithmeticException e) {
            throw new ValueConversionException(XQEMessageKeys.DAT_DecimalOverflowError, right.toString(), Integer.toString(left.precision()), Integer.toString(left.scale()));
        }
    }

    public static void floor(int i, BigDecimal input, DecimalColumnVector outputColVector) {
        outputColVector.set(i, input.setScale(0, 3));
    }

    public static void ceiling(int i, BigDecimal input, DecimalColumnVector outputColVector) {
        outputColVector.set(i, input.setScale(0, 2));
    }

    public static void round(int i, BigDecimal input, int decimalPlaces, DecimalColumnVector outputColVector) {
        outputColVector.set(i, input.setScale(decimalPlaces, 4));
    }

    public static void round(int i, BigDecimal input, DecimalColumnVector outputColVector) {
        outputColVector.set(i, input.setScale(outputColVector.scale, 4));
    }

    public static void sign(int i, BigDecimal input, LongColumnVector outputColVector) {
        outputColVector.vector[i] = input.signum();
    }

    public static void abs(int i, BigDecimal input, DecimalColumnVector outputColVector) {
        outputColVector.set(i, input.abs());
    }

    public static void negate(int i, BigDecimal input, DecimalColumnVector outputColVector) {
        outputColVector.set(i, input.negate());
    }

    public static void log(int i, BigDecimal input, DoubleColumnVector outputColVector) {
        outputColVector.set(i, StrictMath.log(input.doubleValue()));
    }

    public static void log10(int i, BigDecimal input, DoubleColumnVector outputColVector) {
        outputColVector.set(i, StrictMath.log10(input.doubleValue()));
    }

    public static void exp(int i, BigDecimal input, DoubleColumnVector outputColVector) {
        outputColVector.set(i, StrictMath.exp(input.doubleValue()));
    }

    public static void sqrt(int i, BigDecimal input, DoubleColumnVector outputColVector) {
        outputColVector.set(i, StrictMath.sqrt(input.doubleValue()));
    }
}

