/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XAggregate;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.trace.XQETrace;

public class XVectorAggregate
extends XAggregate {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorAggregateResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501188;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        this.vContext.dumpInfo(trace);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    protected class XVectorAggregateResultSet
    extends XAggregate.XAggregateResultSet {
        public XVectorAggregateResultSet(XDataContext context) {
            super(XVectorAggregate.this, context);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorAggregateIterator(this.getDataContext());
        }

        protected class XVectorAggregateIterator
        extends XAggregate.XAggregateResultSet.XAggregateIterator {
            private XVectorRowBatch batch;
            private boolean eod;

            public XVectorAggregateIterator(XDataContext context) {
                super(XVectorAggregateResultSet.this, context);
                this.batch = XVectorRowBatchUtil.createRowBatch(XVectorAggregate.this.vContext, XVectorAggregateResultSet.this.rowsetInfo, context.getLocalCollator());
            }

            @Override
            public Object nextBatch() {
                this.batch.reset();
                if (this.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                while (this.batch.size != this.batch.maxBatchSize) {
                    IRow row = (IRow)this.nextImpl();
                    if (row == null) {
                        this.eod = true;
                        if (this.batch.size != 0) break;
                        this.batch.eod = true;
                        break;
                    }
                    this.batch.addRow(row);
                }
                return this.batch;
            }
        }
    }

    protected final class IteratorBuffer
    extends XAggregate.IteratorBuffer {
        private XVectorRowBatch batch;

        public IteratorBuffer(XDataContext context, ITabularResultSet iResultSet) {
            super(XVectorAggregate.this, context, iResultSet);
            this.currentRow = DataValueFactory.createRowValue(context.getLocalCollator(), iResultSet.getTabularRowsetInfo());
        }

        @Override
        protected IRow getNextRow() {
            if (this.batch == null || ++this.batch.index == this.batch.size) {
                this.batch = (XVectorRowBatch)this.inputIterator.nextBatch();
                if (this.batch.eod) {
                    return null;
                }
            }
            this.batch.getRow(this.currentRow);
            return this.currentRow;
        }
    }
}

