/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.runtree.relational.vectorization.XVectorBatchPartition;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSetFunction;
import java.util.LinkedList;

public class XVectorBatchPartitionSet {
    private LinkedList<XVectorBatchPartition> partitionsForReuse = new LinkedList();
    private LinkedList<XVectorBatchPartition> partitionsForBatch = new LinkedList();
    private XVectorBatchPartition[] partitions = new XVectorBatchPartition[1024];

    public void assignPartitions(XVectorSetFunction[] functionList, XVectorRowBatch batch, int[] keys, int[] dependents) {
        XVectorBatchPartition partition;
        if (this.partitionsForBatch.isEmpty()) {
            partition = new XVectorBatchPartition(functionList, XVectorRowBatchUtil.copyRowBatchStructure(batch, 1));
            partition.setKeyValues(batch, 0, keys, dependents);
            this.partitionsForBatch.add(partition);
        } else {
            partition = this.partitionsForBatch.getLast();
        }
        for (int i = 0; i < batch.size; ++i) {
            if (!batch.equals(partition.getKeys(), i, 0, keys)) {
                if (this.partitionsForReuse.size() > 0) {
                    partition = this.partitionsForReuse.remove();
                    partition.reset();
                } else {
                    partition = new XVectorBatchPartition(functionList, XVectorRowBatchUtil.copyRowBatchStructure(batch, 1));
                }
                partition.setKeyValues(batch, i, keys, dependents);
                this.partitionsForBatch.add(partition);
            }
            this.partitions[i] = partition;
        }
    }

    public XVectorBatchPartition getPartition(int index) {
        return this.partitions[index];
    }

    public XVectorBatchPartition[] getPartitions() {
        return this.partitions;
    }

    public int size() {
        return this.partitionsForBatch.size();
    }

    public XVectorBatchPartition getFirst() {
        return this.partitionsForBatch.getFirst();
    }

    public XVectorBatchPartition remove() {
        XVectorBatchPartition partition = this.partitionsForBatch.remove();
        this.partitionsForReuse.add(partition);
        return partition;
    }

    public void set(int i, XVectorBatchPartition partition) {
        this.partitions[i] = partition;
    }
}

