/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.VectorizedHashKeysSet;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorJoin;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import gnu.trove.map.hash.THashMap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.dom4j.Element;

public class XVectorHashJoin
extends XVectorJoin {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_NO_DUPLICATES_IN_BUILD_TABLE = "noDuplicatesInBuildTable";
    private boolean noDuplicatesInBuildTable;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XVectorHashJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501183;
    }

    public void setNoDuplicatesInBuildTable(boolean flag) {
        this.noDuplicatesInBuildTable = flag;
    }

    @Override
    protected void dumpAttributes(XQETrace trace) {
        super.dumpAttributes(trace);
        trace.attribute(ATTRIBUTE_NO_DUPLICATES_IN_BUILD_TABLE, this.noDuplicatesInBuildTable);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        super.capture(env, inputNode);
        String attr = inputNode.attributeValue(ATTRIBUTE_NO_DUPLICATES_IN_BUILD_TABLE);
        if (attr != null) {
            this.noDuplicatesInBuildTable = Boolean.valueOf(attr);
        }
    }

    private final class XVectorHashJoinResultSet
    extends XVectorJoin.ResultSet
    implements ITabularResultSet {
        XVectorHashJoinResultSet(XDataContext theContext) {
            super(theContext, 2, XVectorHashJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorHashJoinIterator(this.getDataContext());
        }

        private final class XVectorHashJoinIterator
        extends XVectorTabularIterator {
            private static final int BUILD_INDEX = 0;
            private static final int PROBE_INDEX = 1;
            private ITabularIterator probeIterator;
            private XVectorRowBatch probeBatch;
            private IRowsetInfo probeRowsetInfo;
            private Iterator<VectorizedHashKeysSet> listIterator;
            private CompletableList<VectorizedHashKeysSet> currentList;
            private FileBasedPersistedResultSet probeScan;
            private int[] probeBatchWriteSelection;
            private int probeBatchWriteSelectionSize;
            private VectorBuildTable buildTable;
            private XVectorRowBatch dummyBuildRow;

            private XVectorHashJoinIterator(XDataContext context) {
                super(context, XVectorHashJoin.this.getId(), XVectorHashJoinResultSet.this.rowsetInfo);
                this.probeRowsetInfo = null;
                this.listIterator = null;
                this.currentList = null;
                this.probeScan = null;
                this.probeBatchWriteSelectionSize = 0;
                this.buildTable = null;
                this.dummyBuildRow = null;
                try {
                    this.startTimer();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorHashJoin.this.vContext, XVectorHashJoinResultSet.this.rowsetInfo, context.getLocalCollator());
                    this.probeRowsetInfo = XVectorHashJoinResultSet.this.iResultSets[1].getTabularRowsetInfo();
                    this.probeIterator = XVectorHashJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.buildTable = new VectorBuildTable();
                    this.dummyBuildRow = XVectorRowBatchUtil.createRowBatch(XVectorHashJoinResultSet.this.iResultSets[0].getTabularRowsetInfo(), context.getLocalCollator());
                    this.dummyBuildRow.size = this.dummyBuildRow.maxBatchSize;
                    for (ColumnVector c : this.dummyBuildRow.columns) {
                        c.isRepeating = true;
                        c.isNull[0] = true;
                        c.noNulls = false;
                    }
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                this.batch.reset();
                block0: while (!(this.batch.size >= this.batch.maxBatchSize || this.probeBatch != null && this.probeBatch.eod)) {
                    block8: {
                        if (this.listIterator != null) {
                            if (this.listIterator.hasNext()) {
                                VectorizedHashKeysSet buildRow = this.listIterator.next();
                                XVectorRowBatch buildBatch = buildRow.getRowBatch();
                                buildBatch.index = buildRow.getRowBatchIndex();
                                XVectorHashJoinResultSet.this.combine(this.batch, buildBatch, this.probeBatch, XJoin.State.EQUAL);
                                continue;
                            }
                            this.listIterator = null;
                            if (!this.currentList.isComplete()) {
                                this.writeProbeRow();
                            }
                            this.currentList = null;
                        }
                        while (true) {
                            this.getNextProbeRow();
                            if (this.probeBatch.eod) continue block0;
                            this.buildTable.matchProbeRow();
                            if (this.currentList != null) break block8;
                            if (!this.buildTable.lastPartition()) {
                                this.writeProbeRow();
                                continue;
                            }
                            if (XVectorHashJoin.this.joinType == XJoin.JoinType.RIGHT_OUTER) break;
                        }
                        XVectorHashJoinResultSet.this.combine(this.batch, this.dummyBuildRow, this.probeBatch, XJoin.State.GREATER_THAN);
                        continue;
                    }
                    this.listIterator = this.currentList.iterator();
                }
                if (this.probeBatch.eod && this.batch.size == 0) {
                    this.batch.eod = true;
                } else {
                    this.cleanBatchFromNonMatchingRows();
                }
                return this.batch;
            }

            private void cleanBatchFromNonMatchingRows() {
                int k;
                int j;
                int nLeftValues = XVectorHashJoinResultSet.this.iRowsetInfo[0].getNumColumns();
                if (XJoin.JoinType.LEFT_OUTER != XVectorHashJoin.this.joinType && XJoin.JoinType.RIGHT_OUTER != XVectorHashJoin.this.joinType) {
                    return;
                }
                BitSet bitSet = new BitSet(this.batch.size);
                for (j = 0; j < this.buildTable.buildJoinColumns.length; ++j) {
                    int buildColumnId = this.buildTable.buildJoinColumns[j];
                    int probeColumnId = this.buildTable.probeJoinColumns[j] + nLeftValues;
                    ColumnVector buildColumn = this.batch.columns[buildColumnId];
                    ColumnVector probeColumn = this.batch.columns[probeColumnId];
                    for (int i = 0; i < this.batch.size; ++i) {
                        if (0 == ColumnVector.compareWithImplicitCast(buildColumn, i, probeColumn, i)) continue;
                        bitSet.set(i);
                    }
                }
                if (XJoin.JoinType.LEFT_OUTER == XVectorHashJoin.this.joinType) {
                    for (j = 0; j < XVectorHashJoinResultSet.this.iRowsetInfo[1].getNumColumns(); ++j) {
                        ColumnVector probeColumn = this.batch.columns[j + nLeftValues];
                        k = bitSet.nextSetBit(0);
                        if (probeColumn instanceof DecimalColumnVector) {
                            while (-1 != k) {
                                probeColumn.setNull(k);
                                ((DecimalColumnVector)probeColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else if (probeColumn instanceof IntervalColumnVector) {
                            while (-1 != k) {
                                probeColumn.setNull(k);
                                ((IntervalColumnVector)probeColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else if (probeColumn instanceof StringColumnVector) {
                            while (-1 != k) {
                                probeColumn.setNull(k);
                                ((StringColumnVector)probeColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else if (probeColumn instanceof TimestampColumnVector) {
                            while (-1 != k) {
                                probeColumn.setNull(k);
                                ((TimestampColumnVector)probeColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else {
                            while (-1 != k) {
                                probeColumn.setNull(k);
                                k = bitSet.nextSetBit(k + 1);
                            }
                        }
                        probeColumn.isRepeating = false;
                    }
                } else {
                    for (j = 0; j < XVectorHashJoinResultSet.this.iRowsetInfo[0].getNumColumns(); ++j) {
                        ColumnVector buildColumn = this.batch.columns[j];
                        k = bitSet.nextSetBit(0);
                        if (buildColumn instanceof DecimalColumnVector) {
                            while (-1 != k) {
                                buildColumn.setNull(k);
                                ((DecimalColumnVector)buildColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else if (buildColumn instanceof IntervalColumnVector) {
                            while (-1 != k) {
                                buildColumn.setNull(k);
                                ((IntervalColumnVector)buildColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else if (buildColumn instanceof StringColumnVector) {
                            while (-1 != k) {
                                buildColumn.setNull(k);
                                ((StringColumnVector)buildColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else if (buildColumn instanceof TimestampColumnVector) {
                            while (-1 != k) {
                                buildColumn.setNull(k);
                                ((TimestampColumnVector)buildColumn).vector[k] = null;
                                k = bitSet.nextSetBit(k + 1);
                            }
                        } else {
                            while (-1 != k) {
                                buildColumn.setNull(k);
                                k = bitSet.nextSetBit(k + 1);
                            }
                        }
                        buildColumn.isRepeating = false;
                    }
                }
            }

            private void writeProbeRow() {
                if (this.probeScan == null) {
                    this.probeScan = new FileBasedPersistedResultSet(this.probeRowsetInfo.getDataType(), this.context);
                }
                if (this.probeBatchWriteSelection == null) {
                    this.probeBatchWriteSelection = new int[this.probeBatch.selected.length];
                }
                this.probeBatchWriteSelection[this.probeBatchWriteSelectionSize] = this.probeBatch.index;
                ++this.probeBatchWriteSelectionSize;
            }

            private void getNextProbeRow() {
                while (true) {
                    if (this.probeBatch != null && this.probeBatch.index < this.probeBatch.size - 1) {
                        ++this.probeBatch.index;
                        break;
                    }
                    if (this.probeScan != null && this.probeBatchWriteSelectionSize > 0) {
                        this.probeBatch.size = this.probeBatchWriteSelectionSize;
                        this.probeBatch.selected = this.probeBatchWriteSelection;
                        this.probeBatch.selectedInUse = true;
                        this.probeScan.write(this.probeBatch);
                        this.probeBatchWriteSelectionSize = 0;
                        this.probeBatchWriteSelection = null;
                    }
                    this.probeBatch = (XVectorRowBatch)this.probeIterator.nextBatch();
                    this.probeBatch.index = 0;
                    if (!this.probeBatch.eod) break;
                    this.probeIterator.release();
                    this.probeIterator = null;
                    if (this.probeScan == null) break;
                    this.probeIterator = this.probeScan.getVectorizedIterator(this.probeRowsetInfo, XVectorHashJoin.this.vContext);
                    this.probeScan = null;
                    this.probeBatch = null;
                    if (this.buildTable.lastPartition()) {
                        throw new RuntimeException("Incorrect state - build there is no more build partitions, but the probe table is saved");
                    }
                    this.buildTable.loadNextPartition();
                }
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                this.buildTable.release();
                try {
                    if (this.probeIterator != null) {
                        this.probeIterator.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.probeIterator = null;
                }
                if (this.probeScan != null) {
                    this.probeScan.release();
                    this.probeScan = null;
                }
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorHashJoin.this.vContext;
            }

            public class CompletableList<T>
            extends LinkedList<T> {
                private static final long serialVersionUID = 1L;
                private boolean complete = true;

                public void setComplete(boolean theComplete) {
                    this.complete = theComplete;
                }

                public boolean isComplete() {
                    return this.complete;
                }
            }

            private class VectorBuildTable {
                private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
                private Map<VectorizedHashKeysSet, CompletableList<VectorizedHashKeysSet>> hashMap = null;
                private ITabularIterator buildIterator = null;
                private XVectorRowBatch buildBatch;
                private XVectorRowBatch inputBatch;
                private long memory = 0L;
                private int[] buildJoinColumns = null;
                private int[] probeJoinColumns = null;
                private boolean useFastHash = true;
                private IRowsetInfo buildRowsetInfo = null;
                private VectorizedHashKeysSet probeKeys = null;
                private boolean first = true;
                private boolean joinThroughCompatibleDataType = true;

                VectorBuildTable() {
                    int i;
                    int nJoins = XVectorHashJoin.this.joins.size();
                    this.buildJoinColumns = new int[nJoins];
                    this.probeJoinColumns = new int[nJoins];
                    for (i = 0; i < nJoins; ++i) {
                        Join join = (Join)XVectorHashJoin.this.joins.get(i);
                        this.buildJoinColumns[i] = join.getLeftJoin().getColumnNo();
                        this.probeJoinColumns[i] = join.getRightJoin().getColumnNo();
                    }
                    this.buildRowsetInfo = XVectorHashJoinResultSet.this.iResultSets[0].getTabularRowsetInfo();
                    for (i = 0; i < nJoins; ++i) {
                        IDataType dt1 = this.buildRowsetInfo.getColumnInfo(this.buildJoinColumns[i]).getDataType();
                        IDataType dt2 = XVectorHashJoinIterator.this.probeRowsetInfo.getColumnInfo(this.probeJoinColumns[i]).getDataType();
                        if (this.useFastHash && dt1.getCCLTypeCode() != dt2.getCCLTypeCode()) {
                            this.useFastHash = false;
                        }
                        if (!this.joinThroughCompatibleDataType || DataTypeComparator.areCompatibleDataTypes(dt1, dt2)) continue;
                        this.joinThroughCompatibleDataType = false;
                    }
                    this.buildIterator = XVectorHashJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.hashMap = new THashMap();
                    this.probeKeys = new VectorizedHashKeysSet(this.probeJoinColumns, this.useFastHash, !this.joinThroughCompatibleDataType);
                }

                public void matchProbeRow() {
                    if (this.first) {
                        this.first = false;
                        this.loadNextPartition();
                    }
                    int index = ((XVectorHashJoinIterator)XVectorHashJoinIterator.this).probeBatch.index;
                    if (((XVectorHashJoinIterator)XVectorHashJoinIterator.this).probeBatch.selectedInUse) {
                        index = ((XVectorHashJoinIterator)XVectorHashJoinIterator.this).probeBatch.selected[index];
                    }
                    for (int i = 0; i < XVectorHashJoin.this.joins.size(); ++i) {
                        if (!((XVectorHashJoinIterator)XVectorHashJoinIterator.this).probeBatch.columns[this.probeJoinColumns[i]].isNull[index] || ((Join)XVectorHashJoin.this.joins.get(i)).isNotDistinctFrom()) continue;
                        XVectorHashJoinIterator.this.currentList = null;
                        return;
                    }
                    this.probeKeys.set(XVectorHashJoinIterator.this.probeBatch, index);
                    XVectorHashJoinIterator.this.currentList = this.hashMap.get(this.probeKeys);
                }

                public boolean lastPartition() {
                    return this.buildIterator == null;
                }

                private void loadNextPartition() {
                    FileBasedPersistedResultSet scan = null;
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XVectorHashJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                        this.memory = 0L;
                    }
                    XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
                    Runtime rt = Runtime.getRuntime();
                    logger.log(String.format("VectorHashJoin - start building partition. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                    VectorizedHashKeysSet currentHashKey = new VectorizedHashKeysSet(this.buildJoinColumns, this.useFastHash, !this.joinThroughCompatibleDataType);
                    while (true) {
                        long memoryToRelease;
                        boolean forced;
                        long batchSize;
                        this.buildBatch = XVectorRowBatchUtil.createRowBatch(this.buildRowsetInfo, XVectorHashJoinIterator.this.context.getLocalCollator());
                        try {
                            while (true) {
                                if (this.inputBatch == null) {
                                    this.inputBatch = (XVectorRowBatch)this.buildIterator.nextBatch();
                                }
                                if (this.inputBatch.eod) {
                                    this.buildBatch.eod = this.buildBatch.size == 0;
                                } else if (this.buildBatch.maxBatchSize - this.buildBatch.size >= this.inputBatch.size) {
                                    this.buildBatch.merge(this.inputBatch);
                                    this.inputBatch = null;
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (RuntimeException e) {
                            if (scan != null) {
                                scan.release();
                            }
                            this.release();
                            throw e;
                        }
                        if (this.buildBatch.eod) {
                            XVectorContext vc = XVectorHashJoin.this.vContext;
                            if (this.buildIterator instanceof XTabularIterator && null != ((XTabularIterator)this.buildIterator).getVectorizationContext()) {
                                vc = (XVectorContext)((XTabularIterator)this.buildIterator).getVectorizationContext();
                            }
                            this.buildIterator.release();
                            this.buildIterator = null;
                            if (scan != null) {
                                this.buildIterator = scan.getVectorizedIterator(this.buildRowsetInfo, vc);
                                this.inputBatch = null;
                                scan = null;
                            }
                            break;
                        }
                        long memRequired = batchSize = (long)this.buildBatch.sizeOf();
                        long memEstimate = batchSize;
                        memEstimate += (long)(currentHashKey.sizeOf() * this.buildBatch.size + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE) * this.buildBatch.size);
                        boolean bl = forced = this.hashMap.size() == 0;
                        if (scan != null) {
                            scan.write(this.buildBatch);
                        } else if (!XVectorHashJoinIterator.this.context.getMemoryManager().allocateMemory(memEstimate, forced)) {
                            logger.log(String.format("VectorHashJoin - building partition, revert to scanner (new set). Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                            scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XVectorHashJoinIterator.this.context);
                            scan.write(this.buildBatch);
                        } else {
                            this.memory += memEstimate;
                        }
                        for (int j = 0; j < this.buildBatch.size; ++j) {
                            boolean ignore = false;
                            for (int i = 0; i < XVectorHashJoin.this.joins.size(); ++i) {
                                if (!this.buildBatch.columns[i].isNull[j] || ((Join)XVectorHashJoin.this.joins.get(i)).isNotDistinctFrom()) continue;
                                ignore = true;
                                break;
                            }
                            if (ignore) continue;
                            currentHashKey.set(this.buildBatch, j);
                            CompletableList<VectorizedHashKeysSet> list = this.hashMap.get(currentHashKey);
                            if (list == null) {
                                if (scan != null) continue;
                                list = new CompletableList();
                                VectorizedHashKeysSet newKey = currentHashKey.copy();
                                list.add(newKey);
                                this.hashMap.put(newKey, list);
                                memRequired += (long)(currentHashKey.sizeOf() + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE));
                                continue;
                            }
                            if (scan == null) {
                                if (XVectorHashJoin.this.noDuplicatesInBuildTable) continue;
                                list.add(currentHashKey.copy());
                                memRequired += (long)currentHashKey.sizeOf();
                                continue;
                            }
                            list.setComplete(false);
                        }
                        if (scan != null || (memoryToRelease = memEstimate - memRequired) <= 0L) continue;
                        XVectorHashJoinIterator.this.context.getMemoryManager().releaseMemory(memoryToRelease);
                        this.memory -= memoryToRelease;
                    }
                    logger.log(String.format("VectorHashJoin - building partition, EOD. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                }

                void release() {
                    try {
                        if (this.buildIterator != null) {
                            this.buildIterator.release();
                        }
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.buildIterator = null;
                    }
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XVectorHashJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                        this.memory = 0L;
                    }
                }
            }
        }
    }
}

