/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatchUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XVectorProject
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_OUTPUTLIST = "OutputList";
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private XVectorExpression[] outputList;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorProjectResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501171;
    }

    public IExecutable[] getOutputList() {
        return this.outputList;
    }

    public void setOutputList(XVectorExpression[] theOutputList) {
        this.outputList = theOutputList;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    @Override
    public void clearPlanningEnvironment() {
        super.clearPlanningEnvironment();
        if (this.outputList != null && this.outputList.length != 0) {
            for (XVectorExpression outputNode : this.outputList) {
                ((XQEBaseQueryNode)outputNode).clearPlanningEnvironment();
            }
        }
    }

    @Override
    public void recursiveSetPlanningEnvironment(IPlanningEnvironment planningEnvironment) {
        super.recursiveSetPlanningEnvironment(planningEnvironment);
        if (this.outputList != null && this.outputList.length != 0) {
            for (XVectorExpression outputNode : this.outputList) {
                ((XQEBaseQueryNode)outputNode).recursiveSetPlanningEnvironment(planningEnvironment);
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_CONTEXTNO, String.valueOf(this.contextNo));
        this.vContext.dumpInfo(trace);
        trace.beginElement(ELEMENT_OUTPUTLIST);
        for (int i = 0; i < this.outputList.length; ++i) {
            this.outputList[i].dump(trace);
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        List elements = inputNode.elements();
        Iterator it = elements.iterator();
        Element child = (Element)it.next();
        this.vContext = new XVectorContext();
        this.vContext.capture(env, child);
        child = (Element)it.next();
        List exprList = child.elements();
        this.outputList = new XVectorExpression[exprList.size()];
        for (int i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            String className = child.getName();
            Attribute attribute = child.attribute("package");
            if (attribute != null) {
                className = attribute.getText() + "." + className;
            }
            XNode xNode = (XNode)nodeFactory.createNodeByName(className);
            xNode.capture(env, child);
            this.outputList[i] = (XVectorExpression)xNode;
        }
        this.capture(env, inputNode, elements.size() - 1);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        ctx.elementProperty(ELEMENT_OUTPUTLIST, this.outputList);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_OUTPUTLIST)) {
            Object val = ctx.elementValue(node);
            this.outputList = (XVectorExpression[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XVectorProjectResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;
        private int[] projectedColumns;

        XVectorProjectResultSet(XDataContext context) {
            super(context, XVectorProject.this.getId());
            try {
                this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorProject.this.getChild(0))).execute(context);
                this.rowsetInfo = new RowsetInfo();
                IRowsetInfo iRowsetInfo = this.iResultSet.getTabularRowsetInfo();
                this.projectedColumns = new int[XVectorProject.this.outputList.length];
                for (int i = 0; i < XVectorProject.this.outputList.length; ++i) {
                    XVectorExpression xExprNode = XVectorProject.this.outputList[i];
                    this.projectedColumns[i] = xExprNode.getColumnNo();
                    String name = xExprNode.getName(iRowsetInfo, i);
                    IDataType dType = xExprNode.getDataType(iRowsetInfo, i);
                    this.rowsetInfo.addColumnInfo(new ColumnInfo(name, dType));
                }
                for (XVectorExpression xExpr : XVectorProject.this.outputList) {
                    xExpr.open(context, iRowsetInfo);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorProjectIterator(this.getDataContext(), this.iResultSet);
        }

        @Override
        public XVectorContext getVectorizationContext() {
            return XVectorProject.this.vContext;
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            for (XVectorExpression xExpr : XVectorProject.this.outputList) {
                xExpr.close(this.getDataContext());
            }
            this.rowsetInfo = null;
        }

        private final class XVectorProjectIterator
        extends XVectorTabularIterator {
            private ITabularIterator tabIt;
            private boolean firstBatch;

            private XVectorProjectIterator(XDataContext context, ITabularResultSet resultSet) {
                super(context, XVectorProject.this.getId(), XVectorProjectResultSet.this.rowsetInfo);
                this.firstBatch = true;
                try {
                    this.startTimer();
                    this.tabIt = resultSet.getTabularIterator();
                    this.batch = XVectorRowBatchUtil.createRowBatch(XVectorProject.this.vContext, XVectorProjectResultSet.this.rowsetInfo, context.getLocalCollator());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextBatch() {
                int i;
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                this.batch.reset();
                XVectorRowBatch inputBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                if (inputBatch.eod) {
                    this.batch.eod = true;
                    return this.batch;
                }
                for (i = 0; i < XVectorProject.this.outputList.length; ++i) {
                    XVectorProject.this.outputList[i].evaluate(this.context, inputBatch);
                }
                if (this.firstBatch) {
                    for (i = 0; i < XVectorProject.this.outputList.length; ++i) {
                        ColumnVector vector = inputBatch.columns[XVectorProjectResultSet.this.projectedColumns[i]];
                        this.batch.columns[i].setFormatID(vector.getFormatId());
                    }
                }
                if (inputBatch.selectedInUse) {
                    for (i = 0; i < inputBatch.size; ++i) {
                        int srcIndex = inputBatch.selected[i];
                        for (int j = 0; j < XVectorProject.this.outputList.length; ++j) {
                            ColumnVector vector = inputBatch.columns[XVectorProjectResultSet.this.projectedColumns[j]];
                            if (vector.isRepeating) {
                                this.batch.columns[j].assign(i, vector, 0);
                                continue;
                            }
                            this.batch.columns[j].assign(i, vector, srcIndex);
                        }
                    }
                } else {
                    for (int j = 0; j < XVectorProject.this.outputList.length; ++j) {
                        this.batch.columns[j].vectorCopy(inputBatch.columns[XVectorProjectResultSet.this.projectedColumns[j]], inputBatch.size);
                    }
                }
                this.batch.size = inputBatch.size;
                return this.batch;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }

            @Override
            public Object getVectorizationContext() {
                return XVectorProject.this.vContext;
            }
        }
    }
}

