/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class XVectorRowBatch
implements IEncodable {
    public static final int DEFAULT_MAX_BATCH_SIZE = 1024;
    private static final int PRIME = 31;
    public int maxBatchSize;
    public boolean selectedInUse;
    public int[] selected;
    public int size;
    public ColumnVector[] columns;
    public int nScratchColumns;
    public boolean eod;
    public int index;

    public XVectorRowBatch(int nColumns) {
        this(nColumns, 0);
    }

    public XVectorRowBatch(int nColumns, int numberOfScratchColumns) {
        this(nColumns, numberOfScratchColumns, 1024);
    }

    public XVectorRowBatch(int nColumns, int numberOfScratchColumns, int maximumBatchSize) {
        this.maxBatchSize = maximumBatchSize;
        this.selectedInUse = false;
        this.index = -1;
        this.selected = new int[this.maxBatchSize];
        this.columns = new ColumnVector[nColumns];
        this.nScratchColumns = numberOfScratchColumns;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean scratchColumnsOnly) {
        this.selectedInUse = false;
        this.size = 0;
        this.eod = false;
        this.index = -1;
        int start = 0;
        if (scratchColumnsOnly) {
            start = this.columns.length - this.nScratchColumns;
        }
        for (int i = start; i < this.columns.length; ++i) {
            this.columns[i].reset();
        }
    }

    public void complete(int nValues) {
        for (ColumnVector vector : this.columns) {
            vector.complete(nValues);
        }
    }

    public int compare(XVectorRowBatch otherBatch, int columnNo, int vIndex) {
        return this.columns[columnNo].compare(vIndex, otherBatch.columns[columnNo], vIndex);
    }

    public boolean equals(int index1, int index2, int[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            int columnNo = keys[i];
            if (this.columns[columnNo].compare(index1, index2) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(XVectorRowBatch otherBatch, int index1, int index2, int[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            int columnNo = keys[i];
            if (this.columns[columnNo].equals(index1, otherBatch.columns[columnNo], index2)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsWithImplicitCast(XVectorRowBatch otherBatch, int index1, int index2, int[] keys, int[] otherKeys) {
        for (int i = 0; i < keys.length; ++i) {
            int columnNo = keys[i];
            ColumnVector cv1 = this.columns[columnNo];
            int otherColumnNo = otherKeys[i];
            ColumnVector cv2 = otherBatch.columns[otherColumnNo];
            if (ColumnVector.compareWithImplicitCast(cv1, index1, cv2, index2) == 0) continue;
            return false;
        }
        return true;
    }

    public XVectorRowBatch copy() {
        int i;
        XVectorRowBatch copy = new XVectorRowBatch(this.columns.length, this.nScratchColumns);
        copy.eod = this.eod;
        copy.selectedInUse = this.selectedInUse;
        copy.size = this.size;
        if (this.selectedInUse) {
            for (i = 0; i < this.size; ++i) {
                copy.selected[i] = this.selected[i];
            }
        }
        for (i = 0; i < this.columns.length; ++i) {
            copy.columns[i] = this.columns[i].copy(this.size);
        }
        return copy;
    }

    public XVectorRowBatch shallowCopyFrom(XVectorRowBatch otherBatch) {
        this.eod = otherBatch.eod;
        this.selectedInUse = otherBatch.selectedInUse;
        this.size = otherBatch.size;
        if (this.selectedInUse) {
            for (int i = 0; i < this.size; ++i) {
                this.selected[i] = otherBatch.selected[i];
            }
        }
        int nColumns = otherBatch.columns.length - otherBatch.nScratchColumns;
        for (int i = 0; i < nColumns; ++i) {
            this.columns[i] = otherBatch.columns[i];
        }
        return this;
    }

    public XVectorRowBatch copyFrom(XVectorRowBatch otherBatch) {
        this.reset();
        this.eod = otherBatch.eod;
        this.selectedInUse = otherBatch.selectedInUse;
        this.size = otherBatch.size;
        System.arraycopy(otherBatch.selected, 0, this.selected, 0, this.size);
        int nColumns = otherBatch.columns.length - otherBatch.nScratchColumns;
        if (this.selectedInUse) {
            for (int j = 0; j < this.size; ++j) {
                int i = this.selected[j];
                for (int k = 0; k < nColumns; ++k) {
                    this.columns[k].copyFrom(i, otherBatch.columns[k], i);
                }
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                for (int k = 0; k < nColumns; ++k) {
                    this.columns[k].copyFrom(i, otherBatch.columns[k], i);
                }
            }
        }
        return this;
    }

    public XVectorRowBatch merge(XVectorRowBatch otherBatch) {
        if (otherBatch.selectedInUse) {
            for (int j = 0; j < otherBatch.size; ++j) {
                int i = otherBatch.selected[j];
                for (int k = 0; k < this.columns.length; ++k) {
                    this.columns[k].copyFrom(this.size + j, otherBatch.columns[k], i);
                }
            }
        } else {
            for (int i = 0; i < otherBatch.size; ++i) {
                for (int k = 0; k < this.columns.length; ++k) {
                    this.columns[k].copyFrom(this.size + i, otherBatch.columns[k], i);
                }
            }
        }
        this.size += otherBatch.size;
        return this;
    }

    public void copyValues(XVectorRowBatch inputBatch, int dstIndex, int srcIndex, int[] columnsToCopy) {
        for (int i = 0; i < columnsToCopy.length; ++i) {
            this.columns[dstIndex + i].assign(this.size, inputBatch.columns[columnsToCopy[i]], srcIndex);
        }
    }

    public void copyValue(int columnNo, Object value) {
        this.columns[columnNo].assign(this.size, value);
    }

    public void copyValue(int columnNo, IValue value) {
        this.columns[columnNo].assign(this.size, value);
    }

    @Override
    public void encode(XDataContext context, DataOutput oStream) throws IOException {
        oStream.writeInt(this.maxBatchSize);
        oStream.writeInt(this.size);
        oStream.writeBoolean(this.eod);
        if (!this.eod) {
            int nColumns = this.columns.length - this.nScratchColumns;
            for (int i = 0; i < nColumns; ++i) {
                ColumnVector c = this.columns[i];
                int[] propagateSelected = null;
                if (this.selectedInUse) {
                    propagateSelected = this.selected;
                }
                c.encode(context, oStream, this.size, propagateSelected);
            }
        }
    }

    @Override
    public void decode(XDataContext context, DataInput iStream) throws IOException {
        this.maxBatchSize = iStream.readInt();
        this.size = iStream.readInt();
        this.eod = iStream.readBoolean();
        if (!this.eod) {
            int nColumns = this.columns.length - this.nScratchColumns;
            for (int i = 0; i < nColumns; ++i) {
                ColumnVector c = this.columns[i];
                c.decode(context, iStream);
            }
        }
    }

    public int hashCode(int vIndex, int[] keys, boolean useFastHash) {
        int hashkey = 1;
        if (useFastHash) {
            for (int key : keys) {
                hashkey = 31 * hashkey + this.columns[key].fastHash(vIndex);
            }
        } else {
            for (int key : keys) {
                hashkey = 31 * hashkey + this.columns[key].hashCode(vIndex);
            }
        }
        return hashkey;
    }

    @Override
    public int sizeOf() {
        int result = 0;
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT);
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT) * this.selected.length;
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEBOOLEAN);
        result += ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.PRIMITIVEINT);
        for (ColumnVector cVector : this.columns) {
            result += cVector.sizeOf();
        }
        return result;
    }

    public void getRow(IRow currentRow) {
        int i = 0;
        for (ColumnVector cVector : this.columns) {
            cVector.getValue(this.index, (Value)currentRow.getColumn(i++));
        }
    }

    public void getValue(int columnNo, Value value) {
        this.columns[columnNo].getValue(this.index, value);
    }

    public void getValue(int rowNo, int columnNo, Value value) {
        this.columns[columnNo].getValue(rowNo, value);
    }

    public void addRow(IRow row) {
        int nColumns = row.getNumColumns();
        for (int i = 0; i < nColumns; ++i) {
            Value value = (Value)row.getColumn(i);
            ColumnVector cVector = this.columns[i];
            if (cVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
                cVector.setFormatID(value.getFormatId());
            }
            cVector.assign(this.size, value);
        }
        ++this.size;
    }

    public void toXMLString(XMLWriter writer, int startingRowNo) {
        for (int i = 0; i < this.size; ++i) {
            writer.beginElement("row", -1);
            writer.attribute("rowsetId", 0);
            writer.attribute("rowNumber", startingRowNo + i);
            writer.attribute("detailRowNumber", startingRowNo + i);
            writer.attribute("ancestorRowsetId", -1);
            writer.attribute("ancestorRowNumber", -1);
            writer.attribute("coordinate", -1);
            for (int j = 0; j < this.columns.length; ++j) {
                writer.beginElement("value", -1);
                this.columns[j].valueToXMLString(writer, i);
                writer.endElement();
            }
            writer.endElement();
        }
    }
}

