/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class XVectorSearch
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final long MAX_AVALIABLE_MEMORY_SIZE = 10000000L;
    private FileBasedPersistedResultSet sharedBucket;
    private NavigableMap<XVectorRowBatch, SearchSet> indexManager;
    private SearchSet lastSearchSet;
    private int[] columnsToCompare;
    private boolean notIn;
    private int outputColumnNo;

    public XVectorSearch() {
        this.setDataType(DataTypeFactory.getBooleanType());
        this.outputColumnNo = -1;
        this.indexManager = new TreeMap<XVectorRowBatch, SearchSet>(new Comparator<XVectorRowBatch>(){

            @Override
            public int compare(XVectorRowBatch batch0, XVectorRowBatch batch1) {
                int j = 0;
                while (j < batch0.columns.length) {
                    int i;
                    int compareResult;
                    if ((compareResult = batch0.columns[i = j++].compare(batch0.index, batch1.columns[i], batch1.index)) == 0) continue;
                    return compareResult;
                }
                return 0;
            }
        });
    }

    @Override
    public int getType() {
        return 501194;
    }

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        IHybridResultSet resultSet = (IHybridResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        this.loadRowsForSearch(context, resultSet);
        resultSet.release();
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        int i;
        for (int i2 = 1; i2 < this.getNumberChildren(); ++i2) {
            ((XVectorExpression)this.getChild(i2)).evaluate(context, batch);
        }
        int n = batch.size;
        if (n == 0) {
            return;
        }
        long[] output = null;
        if (this.outputColumnNo != -1) {
            LongColumnVector outputColumn = (LongColumnVector)batch.columns[this.outputColumnNo];
            output = outputColumn.vector;
        }
        int newBatchSize = 0;
        ColumnVector[] backupColumns = batch.columns;
        batch.columns = new ColumnVector[this.columnsToCompare.length];
        for (int i3 = 0; i3 < this.columnsToCompare.length; ++i3) {
            batch.columns[i3] = backupColumns[this.columnsToCompare[i3]];
        }
        boolean isRepeating = true;
        for (i = 0; i < batch.columns.length; ++i) {
            isRepeating = isRepeating && batch.columns[i].isRepeating;
        }
        if (isRepeating) {
            batch.index = 0;
            boolean found = false;
            Map.Entry<XVectorRowBatch, SearchSet> indexEntry = this.indexManager.floorEntry(batch);
            if (indexEntry != null) {
                SearchSet aSearchSet = indexEntry.getValue();
                if (aSearchSet == null) {
                    found = false;
                } else {
                    if (aSearchSet != this.lastSearchSet) {
                        this.lastSearchSet.evict();
                    }
                    found = aSearchSet.contains(batch);
                    this.lastSearchSet = aSearchSet;
                }
            }
            int condition = 0;
            condition = found && !this.notIn || !found && this.notIn ? 1 : 0;
            if (output != null) {
                for (int i4 = batch.index; i4 < batch.size; ++i4) {
                    output[i4] = condition;
                }
            } else {
                batch.index = -1;
                if (condition == 0) {
                    batch.size = 0;
                }
            }
            batch.columns = backupColumns;
            return;
        }
        for (i = 0; i < batch.size; ++i) {
            batch.index = batch.selectedInUse ? batch.selected[i] : i;
            boolean found = false;
            Map.Entry<XVectorRowBatch, SearchSet> indexEntry = this.indexManager.floorEntry(batch);
            if (indexEntry != null) {
                SearchSet aSearchSet = indexEntry.getValue();
                if (aSearchSet == null) {
                    found = false;
                } else {
                    if (aSearchSet != this.lastSearchSet) {
                        this.lastSearchSet.evict();
                    }
                    found = aSearchSet.contains(batch);
                    this.lastSearchSet = aSearchSet;
                }
            }
            if (output == null) {
                if ((!found || this.notIn) && (found || !this.notIn)) continue;
                batch.selected[newBatchSize] = batch.index;
                ++newBatchSize;
                continue;
            }
            output[batch.index] = found && !this.notIn || !found && this.notIn ? 1L : 0L;
        }
        batch.columns = backupColumns;
        batch.index = 0;
        if (output == null) {
            batch.size = newBatchSize;
            batch.selectedInUse = true;
        }
    }

    @Override
    public void close(XDataContext context) {
        if (this.sharedBucket != null) {
            this.sharedBucket.release();
            this.sharedBucket = null;
        }
        if (this.indexManager != null) {
            this.indexManager.clear();
        }
        if (this.lastSearchSet != null) {
            this.lastSearchSet.evict();
            this.lastSearchSet = null;
        }
    }

    private void loadRowsForSearch(XDataContext context, IHybridResultSet aResultSet) {
        SearchSet aSearchSet;
        XTabularIterator tabIt = (XTabularIterator)aResultSet.getTabularIterator();
        ArrayList<XVectorRowBatch> valueInMemory = new ArrayList<XVectorRowBatch>();
        XVectorRowBatch inputBatch = (XVectorRowBatch)tabIt.nextBatch();
        long searchSetMemorySize = 0L;
        XVectorRowBatch firstbatch = null;
        long position = -1L;
        int rowCount = 0;
        while (!inputBatch.eod) {
            if (searchSetMemorySize + (long)inputBatch.sizeOf() < 10000000L || this.sharedBucket == null && valueInMemory.isEmpty()) {
                searchSetMemorySize += (long)inputBatch.sizeOf();
                if (this.sharedBucket == null) {
                    valueInMemory.add(inputBatch.copy());
                } else {
                    rowCount += inputBatch.size;
                    this.sharedBucket.write(inputBatch);
                }
            } else {
                if (this.sharedBucket == null) {
                    this.sharedBucket = new FileBasedPersistedResultSet(aResultSet.getTabularRowsetInfo().getDataType(), context, false);
                    aSearchSet = new SearchSet(valueInMemory.toArray(new XVectorRowBatch[valueInMemory.size()]), aResultSet.getTabularRowsetInfo());
                    firstbatch = (XVectorRowBatch)valueInMemory.get(0);
                    valueInMemory.clear();
                    this.lastSearchSet = aSearchSet;
                } else {
                    aSearchSet = new SearchSet(position, rowCount, aResultSet.getTabularRowsetInfo());
                }
                firstbatch.index = 0;
                this.indexManager.put(firstbatch, aSearchSet);
                firstbatch = inputBatch.copy();
                position = this.sharedBucket.write(inputBatch);
                rowCount = inputBatch.size;
                searchSetMemorySize = inputBatch.sizeOf();
            }
            inputBatch = (XVectorRowBatch)tabIt.nextBatch();
        }
        if (!valueInMemory.isEmpty()) {
            if (this.sharedBucket == null) {
                aSearchSet = new SearchSet(valueInMemory.toArray(new XVectorRowBatch[valueInMemory.size()]), aResultSet.getTabularRowsetInfo());
                firstbatch = (XVectorRowBatch)valueInMemory.get(0);
                this.lastSearchSet = aSearchSet;
            } else {
                aSearchSet = new SearchSet(position, rowCount, aResultSet.getTabularRowsetInfo());
            }
            firstbatch.index = 0;
            this.indexManager.put(firstbatch, aSearchSet);
        }
        tabIt.release();
        valueInMemory.clear();
    }

    public void setColumnNumbers(int[] columnIndices) {
        this.columnsToCompare = columnIndices;
    }

    public void setNotIn(boolean not) {
        this.notIn = not;
    }

    public void setOutColumnNumber(int outputCol) {
        this.outputColumnNo = outputCol;
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    private class SearchSet {
        private SearchSetEntry[] values = null;
        private int rowCount;
        private long firstBatchOffSet = -1L;
        private XTabularIterator iterator;
        private IRowsetInfo rowsetInfo;

        SearchSet(long filePosition, int numRows, IRowsetInfo iRowsetInfo) {
            this.firstBatchOffSet = filePosition;
            this.rowCount = numRows;
            this.rowsetInfo = iRowsetInfo;
        }

        SearchSet(XVectorRowBatch[] batches, IRowsetInfo iRowsetInfo) {
            this.rowsetInfo = iRowsetInfo;
            if (XVectorSearch.this.sharedBucket != null) {
                for (XVectorRowBatch batch : batches) {
                    if (this.firstBatchOffSet < 0L) {
                        this.firstBatchOffSet = XVectorSearch.this.sharedBucket.write(batch);
                        continue;
                    }
                    XVectorSearch.this.sharedBucket.write(batch);
                }
            }
            this.rowCount = 0;
            for (int i = 0; i < batches.length; ++i) {
                this.rowCount += batches[i].size;
            }
            this.values = new SearchSetEntry[this.rowCount];
            int current = 0;
            for (int i = 0; i < batches.length; ++i) {
                for (int j = 0; j < batches[i].size; ++j) {
                    this.values[current] = new SearchSetEntry(j, batches[i]);
                    ++current;
                }
            }
        }

        public boolean contains(XVectorRowBatch value) {
            if (this.values == null) {
                this.iterator = XVectorSearch.this.sharedBucket.getVectorizedIterator(this.firstBatchOffSet, this.rowsetInfo, XVectorSearch.this.vContext, false);
                this.values = new SearchSetEntry[this.rowCount];
                int i = 0;
                while (i < this.rowCount) {
                    XVectorRowBatch currentBatch = (XVectorRowBatch)this.iterator.nextBatch();
                    for (int j = 0; j < currentBatch.size; ++j) {
                        this.values[i] = new SearchSetEntry(j, currentBatch);
                        ++i;
                    }
                }
                this.iterator.release();
                return Arrays.binarySearch(this.values, value) >= 0;
            }
            return Arrays.binarySearch(this.values, value) >= 0;
        }

        public void evict() {
            this.values = null;
        }
    }

    private class SearchSetEntry
    implements Comparable<Object> {
        private int index;
        private XVectorRowBatch batch;

        SearchSetEntry(int i, XVectorRowBatch b) {
            this.index = i;
            this.batch = b;
        }

        @Override
        public int compareTo(Object other) {
            XVectorRowBatch otherBatch = null;
            int otherIndex = -1;
            if (other instanceof SearchSetEntry) {
                otherBatch = ((SearchSetEntry)other).batch;
                otherIndex = ((SearchSetEntry)other).index;
            } else if (other instanceof XVectorRowBatch) {
                otherBatch = (XVectorRowBatch)other;
                otherIndex = ((XVectorRowBatch)other).index;
            }
            if (otherIndex == -1) {
                return 0;
            }
            int j = 0;
            while (j < this.batch.columns.length) {
                int i;
                int compareResult;
                if ((compareResult = this.batch.columns[i = j++].compare(this.index, otherBatch.columns[i], otherIndex)) == 0) continue;
                return compareResult;
            }
            return 0;
        }
    }
}

