/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.OrderBy;
import com.cognos.xqe.resultsets.tabular.RowComparator;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.util.VectorSortEngine;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorTabularIterator;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XVectorSort
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_SORTKEYLIST = "SortKeyList";
    private static final String ELEMENT_SORTKEY = "SortKey";
    private static final String ATTRIBUTE_DISTINCT = "distinct";
    private static final String ATTRIBUTE_ASCENDING = "ascending";
    private static final String ATTRIBUTE_NULLSORDERING = "nullOrdering";
    private static final String ATTRIBUTE_POSITION = "position";
    private static final String ATTRIBUTE_LEVEL_NUMBER = "levelNumber";
    private static final String ATTRIBUTE_SORT_MEMBER_BY_CAPTION = "sortMemberByCaption";
    private boolean distinct;
    private boolean sortMemberByCaption = true;
    private OrderBy[] sortKeyList;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XVectorSortResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501179;
    }

    public void setSortKeyList(OrderBy[] list) {
        this.sortKeyList = list;
    }

    public void setSortMemberByCaption(boolean value) {
        this.sortMemberByCaption = value;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        if (this.distinct) {
            trace.attribute(ATTRIBUTE_DISTINCT, this.distinct);
        }
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        this.vContext.dumpInfo(trace);
        trace.beginElement(ELEMENT_SORTKEYLIST);
        for (int i = 0; i < this.sortKeyList.length; ++i) {
            OrderBy sortKey = this.sortKeyList[i];
            trace.beginElement(ELEMENT_SORTKEY);
            trace.attribute(ATTRIBUTE_POSITION, sortKey.getPosition());
            trace.attribute(ATTRIBUTE_ASCENDING, sortKey.isAscending());
            trace.attribute(ATTRIBUTE_NULLSORDERING, sortKey.getNullOrdering().toString());
            if (sortKey.getLevelNo() >= 0) {
                trace.attribute(ATTRIBUTE_LEVEL_NUMBER, sortKey.getLevelNo());
            }
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        List children = inputNode.elements();
        Element child = (Element)children.get(0);
        this.vContext = new XVectorContext();
        this.vContext.capture(env, child);
        child = (Element)children.get(1);
        List keyList = child.elements();
        this.sortKeyList = new OrderBy[keyList.size()];
        for (int i = 0; i < keyList.size(); ++i) {
            int position = 0;
            boolean isAscending = false;
            int levelNumber = -1;
            child = (Element)keyList.get(i);
            position = Integer.valueOf(child.attributeValue(ATTRIBUTE_POSITION));
            isAscending = Boolean.valueOf(child.attributeValue(ATTRIBUTE_ASCENDING));
            String levelNumberString = child.attributeValue(ATTRIBUTE_LEVEL_NUMBER);
            if (levelNumberString != null && !"".equals(levelNumberString)) {
                levelNumber = Integer.parseInt(levelNumberString);
            }
            String nullOrdering = child.attributeValue(ATTRIBUTE_NULLSORDERING);
            this.sortKeyList[i] = new OrderBy(position, levelNumber, isAscending);
            if (nullOrdering == null) continue;
            if (nullOrdering.equals(SQLSortKey.NullOrdering.NULLS_FIRST.toString())) {
                this.sortKeyList[i].setNullOrdering(SQLSortKey.NullOrdering.NULLS_FIRST);
                continue;
            }
            if (nullOrdering.equals(SQLSortKey.NullOrdering.NULLS_LAST.toString())) {
                this.sortKeyList[i].setNullOrdering(SQLSortKey.NullOrdering.NULLS_LAST);
                continue;
            }
            this.sortKeyList[i].setNullOrdering(SQLSortKey.NullOrdering.UNSPECIFIED);
        }
        child = (Element)inputNode.elements().get(2);
        XNode xChild = (XNode)nodeFactory.createNodeByName(child.getName());
        xChild.capture(env, child);
        this.addChild(xChild);
        if ("true".equals(inputNode.attributeValue(ATTRIBUTE_DISTINCT))) {
            this.distinct = true;
        }
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 301089) {
            return true;
        }
        return super.isOfCategory(category);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean vDistinct) {
        this.distinct = vDistinct;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_DISTINCT, this.distinct);
        ctx.property(ATTRIBUTE_SORT_MEMBER_BY_CAPTION, this.sortMemberByCaption);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        ctx.elementProperty(ELEMENT_SORTKEYLIST, this.sortKeyList);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_DISTINCT)) {
            Object val = ctx.attributeValue(att);
            this.distinct = (Boolean)val;
        } else if (attname.equals(ATTRIBUTE_SORT_MEMBER_BY_CAPTION)) {
            Object val = ctx.attributeValue(att);
            this.sortMemberByCaption = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_SORTKEYLIST)) {
            Object val = ctx.elementValue(node);
            this.sortKeyList = (OrderBy[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XVectorSortResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XVectorSortResultSet(XDataContext context) {
            super(context, XVectorSort.this.getId());
            XVectorSort.this.contextNo = XVectorSort.this.getContextNo();
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XVectorSort.this.getChild(0))).execute(this.getDataContext());
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XVectorSortIterator(this.getDataContext());
        }

        @Override
        public XVectorContext getVectorizationContext() {
            return ((IVectorContext)((Object)this.iResultSet)).getVectorizationContext();
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XVectorSortIterator
        extends XVectorTabularIterator {
            private VectorSortEngine sortEngine;
            private ITabularIterator tabIt;

            private XVectorSortIterator(XDataContext context) {
                super(context, XVectorSort.this.getId(), XVectorSortResultSet.this.rowsetInfo);
                try {
                    this.startTimer();
                    this.nRows = 0;
                    RowComparator comparator = new RowComparator(XVectorSortResultSet.this.rowsetInfo, XVectorSort.this.sortKeyList, context.getLocalCollator(), XVectorSort.this.sortMemberByCaption);
                    this.sortEngine = new VectorSortEngine(context, XVectorSortResultSet.this.rowsetInfo, XVectorSort.this.vContext, comparator, XVectorSort.this.distinct);
                    this.tabIt = (XTabularIterator)XVectorSortResultSet.this.iResultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    if (this.tabIt != null && this.sortEngine == null) {
                        this.tabIt.release();
                    }
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            private void loadSortEngine() {
                XVectorRowBatch nextBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                while (!nextBatch.eod) {
                    this.sortEngine.writeBatch(nextBatch);
                    nextBatch = (XVectorRowBatch)this.tabIt.nextBatch();
                }
            }

            @Override
            public Object nextBatch() {
                if (this.nRows == 0) {
                    this.loadSortEngine();
                }
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                XVectorRowBatch batch = this.sortEngine.nextBatch();
                if (batch != null) {
                    this.nRows += batch.size;
                }
                return batch;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    this.tabIt.release();
                }
                if (this.sortEngine != null) {
                    try {
                        this.sortEngine.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.sortEngine = null;
                    }
                }
                super.release();
            }
        }
    }
}

