/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;

public class XVectorTabularIterator
extends XTabularIterator {
    protected XVectorRowBatch batch;
    private IRow row;
    private int index = -1;
    private IRowsetInfo rowsetInfo;

    public XVectorTabularIterator(XDataContext theContext, Integer id, IRowsetInfo theRowsetInfo) {
        super(theContext, id);
        this.rowsetInfo = theRowsetInfo;
    }

    @Override
    public Object nextImpl() {
        if (this.context.isCanceled()) {
            throw new OperationCanceledException(this.context.getCancelSource());
        }
        this.row = DataValueFactory.createRowValue(this.context.getLocalCollator(), this.rowsetInfo);
        while (true) {
            if (this.index < 0) {
                this.batch = (XVectorRowBatch)this.nextBatch();
            }
            if (this.batch.eod) {
                return null;
            }
            if (++this.index < this.batch.size) {
                int srcIndex = this.index;
                if (this.batch.selectedInUse) {
                    srcIndex = this.batch.selected[this.index];
                }
                for (int j = 0; j < this.rowsetInfo.getNumColumns(); ++j) {
                    ColumnVector vector = this.batch.columns[j];
                    int vectorIndex = srcIndex;
                    if (vector.isRepeating) {
                        vectorIndex = 0;
                    }
                    vector.getValue(vectorIndex, (Value)this.row.getColumn(j));
                }
                break;
            }
            this.index = -1;
        }
        if (this.maxRowsRetrievedLimit > 0L) {
            this.throwExceptionIfMaxRowsLimitReached();
        }
        if (this.maxRowsLocalProcessing > 0L) {
            this.throwExceptionIfMaxRowsLocalProcessingLimitReached();
        }
        ++this.nRows;
        return this.row;
    }
}

