/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.util.Arrays;
import org.dom4j.Element;

public class XVectorStringFunction
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_OUTPUTCOLUMNNO = "outputColumnNo";
    private int columnNo;
    private int outputColumnNo;
    protected IUnaryStringFunction function;

    public XVectorStringFunction(int inColumnNo, int inOutputColumnNo) {
        this(inColumnNo, inOutputColumnNo, null);
    }

    public XVectorStringFunction(int inColumnNo, int inOutputColumnNo, IUnaryStringFunction inFunction) {
        this.columnNo = inColumnNo;
        this.outputColumnNo = inOutputColumnNo;
        this.function = inFunction;
    }

    public XVectorStringFunction() {
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        StringColumnVector inputColVector = (StringColumnVector)batch.columns[this.columnNo];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        String[] vector1 = inputColVector.vector;
        if (inputColVector.noNulls) {
            outputColumnVector.noNulls = true;
            if (inputColVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                XVectorStringFunction.setValue(outputColumnVector, 0, this.function.evaluate(vector1[0]));
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputColumnVector.isNull[i] = false;
                    XVectorStringFunction.setValue(outputColumnVector, i, this.function.evaluate(vector1[i]));
                }
                outputColumnVector.isRepeating = false;
            } else {
                Arrays.fill(outputColumnVector.isNull, 0, n, false);
                for (int i = 0; i != n; ++i) {
                    XVectorStringFunction.setValue(outputColumnVector, i, this.function.evaluate(vector1[i]));
                }
                outputColumnVector.isRepeating = false;
            }
        } else {
            outputColumnVector.noNulls = false;
            if (inputColVector.isRepeating) {
                outputColumnVector.isRepeating = true;
                outputColumnVector.isNull[0] = inputColVector.isNull[0];
                if (!inputColVector.isNull[0]) {
                    XVectorStringFunction.setValue(outputColumnVector, 0, this.function.evaluate(vector1[0]));
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    outputColumnVector.isNull[i] = inputColVector.isNull[i];
                    if (inputColVector.isNull[i]) continue;
                    XVectorStringFunction.setValue(outputColumnVector, i, this.function.evaluate(vector1[i]));
                }
                outputColumnVector.isRepeating = false;
            } else {
                System.arraycopy(inputColVector.isNull, 0, outputColumnVector.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputColVector.isNull[i]) continue;
                    XVectorStringFunction.setValue(outputColumnVector, i, this.function.evaluate(vector1[i]));
                }
                outputColumnVector.isRepeating = false;
            }
        }
    }

    private static void setValue(StringColumnVector outputColumnVector, int i, String value) {
        if (value == null) {
            outputColumnVector.noNulls = false;
            outputColumnVector.isNull[i] = true;
            return;
        }
        outputColumnVector.set(i, value);
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
        trace.attribute(ATTRIBUTE_OUTPUTCOLUMNNO, this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_OUTPUTCOLUMNNO));
        super.capture(env, inputNode);
    }

    public static interface IUnaryStringFunction {
        public String evaluate(String var1);
    }
}

