/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.cast;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.generated.XVectorFunctionStringToLong;
import com.cognos.xqe.util.MathUtil;

public class XVectorCastStringToLong
extends XVectorFunctionStringToLong {
    private static final long serialVersionUID = 1L;

    public XVectorCastStringToLong(int inColumnNo, int outColumnNo) {
        super(inColumnNo, outColumnNo);
    }

    @Override
    protected void getResult(LongColumnVector outputVector, StringColumnVector inputVector, int i) {
        String value = inputVector.vector[i];
        if (inputVector.isNull[i] || value.isEmpty()) {
            outputVector.setNull(i);
            return;
        }
        try {
            long result = Long.parseLong(value.trim());
            if (this.dataType.getScale() == 0) {
                outputVector.set(i, result);
            } else {
                outputVector.set(i, result * (long)MathUtil.pow10(this.dataType.getScale()));
            }
        }
        catch (NumberFormatException e) {
            if (this.getOnErrorPolicy() == SQLAbstractFunction.OnErrorPolicy.ERROR) {
                throw new ValueConversionException(XQEMessageKeys.DAT_GeneralConversionError, (Throwable)e, "string", value, "long");
            }
            outputVector.setNull(i);
        }
    }
}

