/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.function.conditional.Like;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.AbstractLikeColumnScalar;
import com.cognos.xqe.trace.XQETrace;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LikeColumnScalar
extends AbstractLikeColumnScalar {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_ESCAPE = "escape";
    private static final List<AbstractLikeColumnScalar.PatternMatcherFactory> MATCHER_FACTORIES = Arrays.asList(new StartsWithCheckerFactory(), new EndsWithCheckerFactory(), new ContainsCheckerFactory(), new NoneCheckerFactory(), new ComplexCheckerFactory());
    protected AbstractLikeColumnScalar.PatternMatcher matcher;

    public LikeColumnScalar(int inColumnNo, String inPattern, String escChar) {
        super(inColumnNo, inPattern, escChar);
    }

    public LikeColumnScalar() {
    }

    @Override
    protected List<AbstractLikeColumnScalar.PatternMatcherFactory> getPatternMatcherFactories() {
        return MATCHER_FACTORIES;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.escCharOrFlags != null) {
            trace.attribute(ATTRIBUTE_ESCAPE, this.escCharOrFlags);
        }
    }

    protected static class ComplexPatternMatcher
    implements AbstractLikeColumnScalar.PatternMatcher {
        Pattern compiledPattern;

        ComplexPatternMatcher(XDataContext context, String pattern) {
            this.compiledPattern = Pattern.compile(pattern, Like.getFlags(context));
        }

        @Override
        public boolean check(byte[] byteS, int len) {
            return this.compiledPattern.matcher(new String(byteS)).matches();
        }
    }

    private static class ComplexCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private ComplexCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String escChar) {
            return new ComplexPatternMatcher(context, Like.likePatternToRegExp(pattern, escChar));
        }
    }

    private static class NoneCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern NONE_PATTERN = Pattern.compile("[^%_]+");

        private NoneCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String escChar) {
            Matcher matcher = NONE_PATTERN.matcher(pattern);
            if (matcher.matches()) {
                return new AbstractLikeColumnScalar.NonePatternMatcher(pattern);
            }
            return null;
        }
    }

    private static class ContainsCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern CONTAINS_PATTERN = Pattern.compile("%([^_%]+)%");

        private ContainsCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String escChar) {
            Matcher matcher;
            if (escChar == null && (matcher = CONTAINS_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.ContainsPatternMatcher(matcher.group(1));
            }
            return null;
        }
    }

    private static class EndsWithCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern ENDS_WITH_PATTERN = Pattern.compile("%([^_%]+)");

        private EndsWithCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String escChar) {
            Matcher matcher;
            if (escChar == null && (matcher = ENDS_WITH_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.EndsWithPatternMatcher(matcher.group(1));
            }
            return null;
        }
    }

    private static class StartsWithCheckerFactory
    implements AbstractLikeColumnScalar.PatternMatcherFactory {
        private static final Pattern STARTS_WITH_PATTERN = Pattern.compile("([^_%]+)%");

        private StartsWithCheckerFactory() {
        }

        @Override
        public AbstractLikeColumnScalar.PatternMatcher tryCreate(XDataContext context, String pattern, String escChar) {
            Matcher matcher;
            if (escChar == null && (matcher = STARTS_WITH_PATTERN.matcher(pattern)).matches()) {
                return new AbstractLikeColumnScalar.StartsWithPatternMatcher(matcher.group(1));
            }
            return null;
        }
    }
}

