/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.SubQueryState;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.XVectorSubQuery;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import java.util.List;
import org.dom4j.Element;

public class XVectorFilterNotEqualAnyPredicate
extends XVectorSubQuery {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private int columnNo;

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        context.setStateObject(this, new State(context, this.getParameters()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        State state = (State)context.getStateObject(this);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (!state.isValid()) {
            this.lock.writeLock().lock();
            try {
                IReleasable resultSet = null;
                IReleasable tabIt = null;
                try {
                    int nChildren = this.getNumberChildren();
                    resultSet = (ITabularResultSet)((IExecutable)((Object)this.getChild(nChildren - 1))).execute(context);
                    tabIt = resultSet.getTabularIterator();
                    XVectorRowBatch inputBatch = (XVectorRowBatch)tabIt.nextBatch();
                    if (!inputBatch.eod) {
                        state.setValue(inputBatch.columns[0].getObject(0));
                        if (inputBatch.size > 1) {
                            state.setTooManyRows(true);
                        } else {
                            state.setTooManyRows(false);
                        }
                    }
                }
                finally {
                    if (tabIt != null) {
                        tabIt.release();
                    }
                    if (resultSet != null) {
                        resultSet.release();
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        if (!state.hasTooManyRows()) {
            Object value = state.getValue();
            if (value == null) {
                batch.size = 0;
            } else if (inputColumnVector.isRepeating) {
                if (inputColumnVector.isNull[0] || !inputColumnVector.equals(0, value)) {
                    batch.size = 0;
                }
            } else {
                int newSize = 0;
                int[] selected = batch.selected;
                if (inputColumnVector.noNulls) {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector.equals(i, value)) continue;
                        selected[newSize++] = i;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (inputColumnVector.isNull[i] || inputColumnVector.equals(i, value)) continue;
                        selected[newSize++] = i;
                    }
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        }
    }

    @Override
    public void close(XDataContext context) {
        context.removeStateObject(this);
    }

    @Override
    public int getType() {
        return 501199;
    }

    public void setInputColumnNo(int inColumnNo) {
        this.columnNo = inColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setContextNo(Integer.valueOf(inputNode.attribute(ATTRIBUTE_CONTEXTNO).getValue()));
        super.capture(env, inputNode);
    }

    private class State
    extends SubQueryState {
        private boolean tooManyRows;

        State(XDataContext context, List<String> parameters) {
            super(context, parameters);
            this.tooManyRows = false;
        }

        public void setTooManyRows(boolean hasTooManyRows) {
            this.tooManyRows = hasTooManyRows;
        }

        public boolean hasTooManyRows() {
            return this.tooManyRows;
        }
    }
}

