/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.XVectorInList;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;

public class XVectorInListString
extends XVectorInList {
    private static final long serialVersionUID = 1L;
    private String[] valueList;

    public XVectorInListString() {
    }

    public XVectorInListString(int inColumnNo, Object[] inValueList, int inOutputColumn) {
        super(inColumnNo, inOutputColumn);
        this.valueList = (String[])Arrays.copyOf(inValueList, inValueList.length, String[].class);
    }

    @Override
    protected boolean contains(ColumnVector inputColumnVector, int index) {
        StringColumnVector columnVector = (StringColumnVector)inputColumnVector;
        Collator collator = columnVector.getCollator();
        for (String value : this.valueList) {
            if (StringUtil.compare(collator, value, columnVector.vector[index]) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dumpValues(XQETrace trace) {
        trace.beginElement("ValueList");
        for (int i = 0; i < this.valueList.length; ++i) {
            trace.beginElement("Value");
            trace.data(this.valueList[i]);
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        List children = inputNode.elements();
        Element child = (Element)children.get(0);
        List values = child.elements();
        this.valueList = new String[values.size()];
        int i = 0;
        for (Element value : values) {
            this.valueList[i++] = (String)value.getData();
        }
    }
}

