/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;

public class XVectorIsNull
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private int outputColumnNo;

    public XVectorIsNull(int theInputColumnNo, int theOutputColumnNo) {
        this.columnNo = theInputColumnNo;
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        outputColumnVector.noNulls = true;
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        long[] outputVector = outputColumnVector.vector;
        if (inputColumnVector.noNulls) {
            outputVector[0] = 0L;
        } else if (inputColumnVector.isRepeating) {
            outputVector[0] = inputIsNull[0] ? 1L : 0L;
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                outputVector[i] = inputIsNull[i] ? 1L : 0L;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = inputIsNull[i] ? 1L : 0L;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

