/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.conditional.LikeColumnScalar;
import com.cognos.xqe.trace.XQETrace;
import java.util.Arrays;

public class XVectorLikeColumnScalar
extends LikeColumnScalar {
    private static final long serialVersionUID = 1L;
    private int outputColumnNo;

    public XVectorLikeColumnScalar(int inColumnNo, String inPattern, String escChar, int theOutputColumnNo) {
        super(inColumnNo, inPattern, escChar);
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        block15: {
            String[] vector;
            boolean[] isNull;
            int[] selected;
            int n;
            block16: {
                StringColumnVector inputColumnVector;
                block14: {
                    super.evaluate(context, batch);
                    n = batch.size;
                    if (n == 0) {
                        return;
                    }
                    if (this.matcher == null) {
                        this.matcher = this.createPatternMatcher(context);
                    }
                    selected = batch.selected;
                    inputColumnVector = (StringColumnVector)batch.columns[this.columnNo];
                    isNull = inputColumnVector.isNull;
                    vector = inputColumnVector.vector;
                    LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
                    long[] outputVector = outputColumnVector.vector;
                    Arrays.fill(outputVector, 0L);
                    if (!inputColumnVector.noNulls) break block14;
                    if (inputColumnVector.isRepeating) {
                        if (this.matcher.check(vector[0].getBytes(), vector[0].length())) {
                            outputVector[0] = 1L;
                        }
                        outputColumnVector.isRepeating = true;
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            if (!this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                            outputVector[i] = 1L;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            if (!this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                            outputVector[i] = 1L;
                        }
                    }
                    break block15;
                }
                if (!inputColumnVector.isRepeating) break block16;
                if (isNull[0]) break block15;
                if (this.matcher.check(vector[0].getBytes(), vector[0].length())) {
                    outputVector[0] = 1L;
                }
                outputColumnVector.isRepeating = true;
                break block15;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (isNull[i] || !this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                    outputVector[i] = 1L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (isNull[i] || !this.matcher.check(vector[i].getBytes(), vector[i].length())) continue;
                    outputVector[i] = 1L;
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }
}

