/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import java.util.Arrays;

public class XVectorSimpleCase
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_COLUMNLIST = "ColumnList";
    public static final String ELEMENT_COLUMN = "Column";
    private int inputColumnNo;
    private String[] compareValues;
    private long[] resultValues;
    private Long elseValue;
    private int outputColumnNo;

    public XVectorSimpleCase(int theInputColumnNo, String[] theCompareValues, long[] theResultValues, Long theElseValue, int theOutputColumnNo) {
        this.inputColumnNo = theInputColumnNo;
        this.compareValues = theCompareValues;
        this.resultValues = theResultValues;
        this.elseValue = theElseValue;
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        Collator collator = context.getLocalCollator();
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.inputColumnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        String[] inputVector = inputColumnVector.vector;
        long[] outputVector = outputColumnVector.vector;
        boolean[] isNull = outputColumnVector.isNull;
        if (inputColumnVector.isRepeating) {
            outputColumnVector.isRepeating = true;
            if (this.elseValue != null) {
                outputColumnVector.vector[0] = this.elseValue;
            } else {
                isNull[0] = true;
            }
            for (int k = 0; k < this.compareValues.length; ++k) {
                if (StringUtil.compare(collator, inputColumnVector.vector[0], this.compareValues[k]) != 0) continue;
                outputVector[0] = this.resultValues[k];
                isNull[0] = false;
                break;
            }
        } else {
            if (this.elseValue != null) {
                Arrays.fill(outputVector, this.elseValue);
            } else {
                Arrays.fill(isNull, true);
            }
            if (batch.selectedInUse) {
                block1: for (int i = 0; i != n; ++i) {
                    int j = selected[i];
                    for (int k = 0; k < this.compareValues.length; ++k) {
                        if (StringUtil.compare(collator, inputVector[j], this.compareValues[k]) != 0) continue;
                        outputVector[j] = this.resultValues[k];
                        isNull[j] = false;
                        continue block1;
                    }
                }
            } else {
                block3: for (int i = 0; i != n; ++i) {
                    for (int k = 0; k < this.compareValues.length; ++k) {
                        if (StringUtil.compare(collator, inputVector[i], this.compareValues[i]) != 0) continue;
                        outputVector[i] = this.resultValues[i];
                        isNull[i] = false;
                        continue block3;
                    }
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
    }
}

