/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.conditional;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.StringUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import java.util.Arrays;

public class XVectorSimpleCaseColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_COLUMNLIST = "ColumnList";
    public static final String ELEMENT_COLUMN = "Column";
    private int inputColumnNo;
    private String[] compareValues;
    private int[] resultColumns;
    private String elseValue;
    private int outputColumnNo;

    public XVectorSimpleCaseColumn(int theInputColumnNo, String[] theCompareValues, int[] theResultColumns, String theElseValue, int theOutputColumnNo) {
        this.inputColumnNo = theInputColumnNo;
        this.compareValues = theCompareValues;
        this.resultColumns = theResultColumns;
        this.elseValue = theElseValue;
        this.outputColumnNo = theOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        Collator collator = context.getLocalCollator();
        int[] selected = batch.selected;
        StringColumnVector inputColumnVector = (StringColumnVector)batch.columns[this.inputColumnNo];
        StringColumnVector outputColumnVector = (StringColumnVector)batch.columns[this.outputColumnNo];
        String[] inputVector = inputColumnVector.vector;
        Object[] outputVector = outputColumnVector.vector;
        boolean[] isNull = outputColumnVector.isNull;
        if (inputColumnVector.isRepeating) {
            outputColumnVector.isRepeating = true;
            if (this.elseValue != null) {
                outputVector[0] = this.elseValue;
            } else {
                isNull[0] = true;
            }
            block0: for (int i = 0; i != n; ++i) {
                for (int k = 0; k < this.compareValues.length; ++k) {
                    if (StringUtil.compare(collator, inputColumnVector.vector[0], this.compareValues[k]) != 0) continue;
                    StringColumnVector resultVector = (StringColumnVector)batch.columns[this.resultColumns[k]];
                    outputVector[i] = resultVector.vector[i];
                    isNull[0] = false;
                    continue block0;
                }
            }
        } else {
            if (this.elseValue != null) {
                Arrays.fill(outputVector, this.elseValue);
            } else {
                Arrays.fill(isNull, true);
            }
            if (batch.selectedInUse) {
                block2: for (int i = 0; i != n; ++i) {
                    int j = selected[i];
                    for (int k = 0; k < this.compareValues.length; ++k) {
                        if (StringUtil.compare(collator, inputVector[j], this.compareValues[k]) != 0) continue;
                        StringColumnVector resultVector = (StringColumnVector)batch.columns[this.resultColumns[k]];
                        outputVector[j] = resultVector.vector[j];
                        isNull[j] = false;
                        continue block2;
                    }
                }
            } else {
                block4: for (int i = 0; i != n; ++i) {
                    for (int k = 0; k < this.compareValues.length; ++k) {
                        if (StringUtil.compare(collator, inputVector[i], this.compareValues[i]) != 0) continue;
                        StringColumnVector resultVector = (StringColumnVector)batch.columns[this.resultColumns[k]];
                        outputVector[i] = resultVector.vector[i];
                        isNull[i] = false;
                        continue block4;
                    }
                }
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
    }
}

