/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorDateAddScalar;
import com.cognos.xqe.util.MathUtil;

public final class XVectorAddSecondsScalar
extends XVectorDateAddScalar {
    private static final long serialVersionUID = 1L;
    private static final int NANOS_PRECISION = 9;

    public XVectorAddSecondsScalar(int columnNo, Number value, int outputColumnNo) {
        super(columnNo, 13, XVectorAddSecondsScalar.getNanoseconds(value.doubleValue()), outputColumnNo);
    }

    @Override
    protected void getResult(TimestampColumnVector outColumnVector, TimestampColumnVector inpColumnVector, int index) {
        TimestampColumnVector.UnixTimestamp inpUxTimestamp = inpColumnVector.vector[index];
        TimestampColumnVector.UnixTimestamp outUxTimestamp = outColumnVector.vector[index];
        long nanoseconds = (long)inpUxTimestamp.nanoseconds + this.value;
        int seconds = (int)(nanoseconds / 1000000000L);
        if ((nanoseconds = (long)((int)(nanoseconds % 1000000000L))) < 0L) {
            --seconds;
            nanoseconds += 1000000000L;
        }
        this.calendar.setTime(this.getTimestamp(inpColumnVector.vector[index]));
        this.calendar.add(13, seconds);
        outUxTimestamp.milliseconds = this.calendar.getTimeInMillis();
        outUxTimestamp.nanoseconds = (int)nanoseconds;
    }

    private static long getNanoseconds(double seconds) {
        double d = seconds * MathUtil.pow10(9);
        return Math.round(d);
    }
}

