/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public abstract class XVectorDateAddScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    protected int columnNo;
    protected long value;
    protected int outputColumnNo;
    protected static final GregorianCalendar GC_VALUE = new GregorianCalendar();
    protected final Calendar calendar = (Calendar)GC_VALUE.clone();
    protected final Timestamp ts = new Timestamp(0L);
    private int field;

    public XVectorDateAddScalar(int theColumnNo, int theField, long theValue, int theOutputColumnNo) {
        this.columnNo = theColumnNo;
        this.value = theValue;
        this.outputColumnNo = theOutputColumnNo;
        this.field = theField;
    }

    protected final Timestamp getTimestamp(TimestampColumnVector.UnixTimestamp uxTimestamp) {
        this.ts.setTime(uxTimestamp.milliseconds);
        this.ts.setNanos(uxTimestamp.nanoseconds);
        return this.ts;
    }

    protected void getResult(TimestampColumnVector outColumnVector, TimestampColumnVector inpColumnVector, int index) {
        TimestampColumnVector.UnixTimestamp inpUxTimestamp = inpColumnVector.vector[index];
        TimestampColumnVector.UnixTimestamp outUxTimestamp = outColumnVector.vector[index];
        this.calendar.setTime(this.getTimestamp(inpColumnVector.vector[index]));
        this.calendar.add(this.field, (int)this.value);
        outUxTimestamp.milliseconds = this.calendar.getTimeInMillis();
        outUxTimestamp.nanoseconds = inpUxTimestamp.nanoseconds;
    }

    protected void getResult(LongColumnVector outColumnVector, LongColumnVector inpColumnVector, int index) {
        this.calendar.setTimeInMillis(inpColumnVector.vector[index]);
        this.calendar.add(this.field, (int)this.value);
        outColumnVector.vector[index] = this.calendar.getTimeInMillis();
    }

    protected void getResult(IntervalColumnVector outColumnVector, IntervalColumnVector inpColumnVector, int index) {
        outColumnVector.assign(index, inpColumnVector);
        outColumnVector.add(index, this.field, (int)this.value);
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        int n = inputColumnVector.isRepeating ? 1 : batch.size;
        if (batch.size == 0) {
            return;
        }
        ColumnVector outputColumnVector = batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        IDataType dType = inputColumnVector.getDataType();
        switch (dType.getCCLTypeCode()) {
            case 57: {
                if (inputColumnVector.isRepeating) {
                    this.getResult((LongColumnVector)outputColumnVector, (LongColumnVector)inputColumnVector, 0);
                    outputIsNull[0] = inputIsNull[0];
                    break;
                }
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult((LongColumnVector)outputColumnVector, (LongColumnVector)inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult((LongColumnVector)outputColumnVector, (LongColumnVector)inputColumnVector, i);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputIsNull[i] = inputIsNull[i];
                            if (inputIsNull[i]) continue;
                            this.getResult((LongColumnVector)outputColumnVector, (LongColumnVector)inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputIsNull[i] = inputIsNull[i];
                            if (inputIsNull[i]) continue;
                            this.getResult((LongColumnVector)outputColumnVector, (LongColumnVector)inputColumnVector, i);
                        }
                    }
                }
                break;
            }
            case 52: 
            case 53: 
            case 58: 
            case 59: {
                if (inputColumnVector.isRepeating) {
                    this.getResult((TimestampColumnVector)outputColumnVector, (TimestampColumnVector)inputColumnVector, 0);
                    outputIsNull[0] = inputIsNull[0];
                    break;
                }
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult((TimestampColumnVector)outputColumnVector, (TimestampColumnVector)inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult((TimestampColumnVector)outputColumnVector, (TimestampColumnVector)inputColumnVector, i);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputIsNull[i] = inputIsNull[i];
                            if (inputIsNull[i]) continue;
                            this.getResult((TimestampColumnVector)outputColumnVector, (TimestampColumnVector)inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputIsNull[i] = inputIsNull[i];
                            if (inputIsNull[i]) continue;
                            this.getResult((TimestampColumnVector)outputColumnVector, (TimestampColumnVector)inputColumnVector, i);
                        }
                    }
                }
                break;
            }
            case 17: 
            case 60: {
                if (inputColumnVector.isRepeating) {
                    this.getResult((IntervalColumnVector)outputColumnVector, (IntervalColumnVector)inputColumnVector, 0);
                    outputIsNull[0] = inputIsNull[0];
                    break;
                }
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult((IntervalColumnVector)outputColumnVector, (IntervalColumnVector)inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult((IntervalColumnVector)outputColumnVector, (IntervalColumnVector)inputColumnVector, i);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputIsNull[i] = inputIsNull[i];
                            if (inputIsNull[i]) continue;
                            this.getResult((IntervalColumnVector)outputColumnVector, (IntervalColumnVector)inputColumnVector, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputIsNull[i] = inputIsNull[i];
                            if (inputIsNull[i]) continue;
                            this.getResult((IntervalColumnVector)outputColumnVector, (IntervalColumnVector)inputColumnVector, i);
                        }
                    }
                }
                break;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        trace.attribute("value", String.valueOf(this.value));
    }

    static {
        GC_VALUE.setFirstDayOfWeek(2);
        GC_VALUE.setMinimalDaysInFirstWeek(4);
        GC_VALUE.clear();
    }
}

