/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtract;

public final class XVectorDayOfWeek
extends XVectorExtract {
    private static final long serialVersionUID = 1L;
    private long beginningOfWeek;

    public XVectorDayOfWeek(int columnNo, long theBeginningOfWeek, int outputColumnNo) {
        super(columnNo, outputColumnNo);
        this.beginningOfWeek = theBeginningOfWeek;
    }

    @Override
    protected void getResult(int index, LongColumnVector inputColumnVector, LongColumnVector outputColumnVector) {
        this.calendar.setTimeInMillis(inputColumnVector.vector[index]);
        long dow = (this.calendar.get(7) + 5) % 7 + 1;
        if (this.beginningOfWeek != 1L && (dow -= this.beginningOfWeek - 1L) < 1L) {
            dow += 7L;
        }
        outputColumnVector.vector[index] = dow;
    }

    @Override
    protected void getResult(int index, TimestampColumnVector inputColumnVector, ColumnVector outputColumnVector) {
        this.calendar.setTime(this.getTimestamp(inputColumnVector.vector[index]));
        long dow = (this.calendar.get(7) + 5) % 7 + 1;
        if (this.beginningOfWeek != 1L && (dow -= this.beginningOfWeek - 1L) < 1L) {
            dow += 7L;
        }
        ((LongColumnVector)outputColumnVector).vector[index] = dow;
    }
}

