/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;

public abstract class XVectorExtract
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    protected int columnNo;
    protected int outputColumnNo;
    protected int field;
    protected static final GregorianCalendar GC_VALUE = new GregorianCalendar();
    protected final Calendar calendar = (Calendar)GC_VALUE.clone();
    protected final Timestamp ts = new Timestamp(0L);

    public XVectorExtract(int theColumnNo, int theOutputColumnNo) {
        this.columnNo = theColumnNo;
        this.outputColumnNo = theOutputColumnNo;
    }

    protected XVectorExtract(int theField, int theColumnNo, int theOutputColumnNo) {
        this.columnNo = theColumnNo;
        this.outputColumnNo = theOutputColumnNo;
        this.field = theField;
    }

    protected final Timestamp getTimestamp(TimestampColumnVector.UnixTimestamp uxTimestamp) {
        this.ts.setTime(uxTimestamp.milliseconds);
        this.ts.setNanos(uxTimestamp.nanoseconds);
        return this.ts;
    }

    protected void getResult(int index, IntervalColumnVector inputColumnVector, LongColumnVector outputColumnVector) {
        IntervalColumnVector.IntervalStruct iStruct = inputColumnVector.vector[index];
        long result = 0L;
        block0 : switch (iStruct.dataType.getSubType()) {
            case INTERVALDTTYPE: {
                switch (this.field) {
                    case 5: {
                        result = iStruct.fields[0];
                        break block0;
                    }
                    case 11: {
                        result = iStruct.fields[1];
                        break block0;
                    }
                    case 12: {
                        result = iStruct.fields[2];
                        break block0;
                    }
                }
                break;
            }
            case INTERVALYMTYPE: {
                switch (this.field) {
                    case 1: {
                        result = iStruct.fields[0];
                        break block0;
                    }
                    case 2: {
                        result = iStruct.fields[1];
                        break block0;
                    }
                }
                break;
            }
        }
        if (iStruct.sign < 0) {
            result = -result;
        }
        outputColumnVector.vector[index] = result;
    }

    protected void getResult(int index, LongColumnVector inputColumnVector, LongColumnVector outputColumnVector) {
        this.calendar.setTimeInMillis(inputColumnVector.vector[index]);
        outputColumnVector.vector[index] = this.calendar.get(this.field);
    }

    protected void getResult(int index, TimestampColumnVector inputColumnVector, ColumnVector outputColumnVector) {
        TimestampColumnVector.UnixTimestamp uxTimestamp = inputColumnVector.vector[index];
        this.calendar.setTime(this.getTimestamp(uxTimestamp));
        ((LongColumnVector)outputColumnVector).vector[index] = this.calendar.get(this.field);
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        int n = inputColumnVector.isRepeating ? 1 : batch.size;
        if (batch.size == 0) {
            return;
        }
        ColumnVector outputColumnVector = batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        IDataType dType = inputColumnVector.getDataType();
        switch (dType.getCCLTypeCode()) {
            case 57: {
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult(i, (LongColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult(i, (LongColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (LongColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (LongColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    }
                }
                break;
            }
            case 60: {
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, (LongColumnVector)outputColumnVector);
                        }
                    }
                }
                break;
            }
            case 52: 
            case 53: 
            case 58: 
            case 59: {
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    }
                }
                break;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("dataType", this.dataType.toString());
        trace.attribute("columnNo", String.valueOf(this.columnNo));
        trace.attribute("outputColumnNo", String.valueOf(this.outputColumnNo));
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    static {
        GC_VALUE.setFirstDayOfWeek(2);
        GC_VALUE.setMinimalDaysInFirstWeek(4);
        GC_VALUE.clear();
    }
}

