/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.date;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.IntervalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.runtree.relational.vectorization.expressions.date.XVectorExtract;
import java.math.BigDecimal;

public final class XVectorExtractSecond
extends XVectorExtract {
    private static final long serialVersionUID = 1L;
    public static final int TEN = 10;

    public XVectorExtractSecond(int columnNo, int outputColumnNo) {
        super(13, columnNo, outputColumnNo);
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        for (IXQEQueryNode child : this.getChildren()) {
            ((XVectorExpression)child).evaluate(context, batch);
        }
        ColumnVector inputColumnVector = batch.columns[this.columnNo];
        int n = inputColumnVector.isRepeating ? 1 : batch.size;
        if (n == 0) {
            return;
        }
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        IDataType dType = inputColumnVector.getDataType();
        switch (dType.getCCLTypeCode()) {
            case 60: {
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, outputColumnVector);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (IntervalColumnVector)inputColumnVector, outputColumnVector);
                        }
                    }
                }
                break;
            }
            default: {
                if (inputColumnVector.noNulls) {
                    outputColumnVector.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    }
                } else {
                    outputColumnVector.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = selected[j];
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outputColumnVector.isNull[i] = inputColumnVector.isNull[i];
                            if (inputColumnVector.isNull[i]) continue;
                            this.getResult(i, (TimestampColumnVector)inputColumnVector, outputColumnVector);
                        }
                    }
                }
                break;
            }
        }
    }

    protected void getResult(int index, IntervalColumnVector inputColumnVector, DecimalColumnVector outputColumnVector) {
        IntervalColumnVector.IntervalStruct iStruct = inputColumnVector.vector[index];
        double seconds = iStruct.fields[3];
        seconds += (double)iStruct.fields[4] / 1.0E9;
        if (iStruct.sign < 0) {
            seconds = -seconds;
        }
        outputColumnVector.vector[index] = BigDecimal.valueOf(seconds);
    }

    protected void getResult(int index, TimestampColumnVector inputColumnVector, DecimalColumnVector outputColumnVector) {
        outputColumnVector.vector[index] = this.getSeconds(inputColumnVector.vector[index]);
    }

    private BigDecimal getSeconds(TimestampColumnVector.UnixTimestamp uxTimestamp) {
        this.calendar.setTime(this.getTimestamp(uxTimestamp));
        double seconds = this.calendar.get(13);
        return BigDecimal.valueOf(seconds += (double)this.ts.getNanos() / 1.0E9);
    }
}

