/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnMultiplyDecimalColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumnNo;

    public XVectorDecimalColumnMultiplyDecimalColumn() {
    }

    public XVectorDecimalColumnMultiplyDecimalColumn(int inColNum1, int inColNum2, int inOutputColumnNo) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DecimalColumnVector inputColumnVector1 = (DecimalColumnVector)batch.columns[this.colNum1];
        DecimalColumnVector inputColumnVector2 = (DecimalColumnVector)batch.columns[this.colNum2];
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
            outputColumnVector.setFormatID("Multiply", inputColumnVector1.getFormatId(), inputColumnVector2.getFormatId());
        }
        int[] selected = batch.selected;
        BigDecimal[] vector1 = inputColumnVector1.vector;
        BigDecimal[] vector2 = inputColumnVector2.vector;
        outputColumnVector.isRepeating = inputColumnVector1.isRepeating && inputColumnVector2.isRepeating || inputColumnVector1.isRepeating && !inputColumnVector1.noNulls && inputColumnVector1.isNull[0] || inputColumnVector2.isRepeating && !inputColumnVector2.noNulls && inputColumnVector2.isNull[0];
        NullUtil.propagateNulls(inputColumnVector1, inputColumnVector2, outputColumnVector, selected, n, batch.selectedInUse);
        if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
            DecimalUtil.multiplyChecked(0, vector1[0], vector2[0], outputColumnVector);
        } else if (inputColumnVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    DecimalUtil.multiplyChecked(i, vector1[0], vector2[i], outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.multiplyChecked(i, vector1[0], vector2[i], outputColumnVector);
                }
            }
        } else if (inputColumnVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    DecimalUtil.multiplyChecked(i, vector1[i], vector2[0], outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.multiplyChecked(i, vector1[i], vector2[0], outputColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                DecimalUtil.multiplyChecked(i, vector1[i], vector2[i], outputColumnVector);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.multiplyChecked(i, vector1[i], vector2[i], outputColumnVector);
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public String getOutputType() {
        return "<ReturnType>";
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("leftColumnNo", this.colNum1);
        trace.attribute("rightColumnNo", this.colNum2);
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.colNum2 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }
}

