/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.ColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.NullUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnSafeDivideDecimalColumn
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumnNo;

    public XVectorDecimalColumnSafeDivideDecimalColumn() {
    }

    public XVectorDecimalColumnSafeDivideDecimalColumn(int inColNum1, int inColNum2, int inOutputColumnNo) {
        this.colNum1 = inColNum1;
        this.colNum2 = inColNum2;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DecimalColumnVector inputColumnVector1 = (DecimalColumnVector)batch.columns[this.colNum1];
        ColumnVector inputColumnVector2 = batch.columns[this.colNum2];
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        int[] selected = batch.selected;
        BigDecimal[] vector1 = inputColumnVector1.vector;
        outputColumnVector.isRepeating = inputColumnVector1.isRepeating && inputColumnVector2.isRepeating || inputColumnVector1.isRepeating && !inputColumnVector1.noNulls && inputColumnVector1.isNull[0] || inputColumnVector2.isRepeating && !inputColumnVector2.noNulls && inputColumnVector2.isNull[0];
        NullUtil.propagateNulls(inputColumnVector1, inputColumnVector2, outputColumnVector, selected, n, batch.selectedInUse);
        if (inputColumnVector1.isRepeating && inputColumnVector2.isRepeating) {
            BigDecimal vector2Val = DecimalUtil.getDecimalValue(inputColumnVector2, 0);
            DecimalUtil.divideChecked(0, vector1[0], vector2Val, outputColumnVector);
        } else if (inputColumnVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    BigDecimal vector2Val = DecimalUtil.getDecimalValue(inputColumnVector2, i);
                    DecimalUtil.divideChecked(i, vector1[0], vector2Val, outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    BigDecimal vector2Val = DecimalUtil.getDecimalValue(inputColumnVector2, i);
                    DecimalUtil.divideChecked(i, vector1[0], vector2Val, outputColumnVector);
                }
            }
        } else if (inputColumnVector2.isRepeating) {
            BigDecimal vector2Val = DecimalUtil.getDecimalValue(inputColumnVector2, 0);
            if (vector2Val.equals(BigDecimal.ZERO)) {
                outputColumnVector.noNulls = false;
                outputColumnVector.isRepeating = true;
                outputColumnVector.isNull[0] = true;
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    DecimalUtil.divideChecked(i, vector1[i], vector2Val, outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.divideChecked(i, vector1[i], vector2Val, outputColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                BigDecimal vector2Val = DecimalUtil.getDecimalValue(inputColumnVector2, i);
                DecimalUtil.divideChecked(i, vector1[i], vector2Val, outputColumnVector);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                BigDecimal vector2Val = DecimalUtil.getDecimalValue(inputColumnVector2, i);
                DecimalUtil.divideChecked(i, vector1[i], vector2Val, outputColumnVector);
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("leftColumnNo", this.colNum1);
        trace.attribute("rightColumnNo", this.colNum2);
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.colNum1 = Integer.valueOf(inputNode.attributeValue("leftColumnNo"));
        this.colNum2 = Integer.valueOf(inputNode.attributeValue("rightColumnNo"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute("dataType").getValue()));
        super.capture(env, inputNode);
    }
}

