/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.DecimalColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.DecimalUtil;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import java.math.BigDecimal;
import org.dom4j.Element;

public class XVectorDecimalColumnSubtractDecimalScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private BigDecimal value;
    private int outputColumnNo;

    public XVectorDecimalColumnSubtractDecimalScalar() {
    }

    public XVectorDecimalColumnSubtractDecimalScalar(int inColumnNo, BigDecimal inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue;
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.columns[this.columnNo];
        DecimalColumnVector outputColumnVector = (DecimalColumnVector)batch.columns[this.outputColumnNo];
        if (outputColumnVector.getFormatId() == FormatId.INVALID_FORMAT_FID) {
            outputColumnVector.setFormatID("Subtract", inputColumnVector.getFormatId(), FormatId.INVALID_FORMAT_FID);
        }
        int[] selected = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColumnVector.isNull;
        outputColumnVector.noNulls = inputColumnVector.noNulls;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        BigDecimal[] vector = inputColumnVector.vector;
        if (inputColumnVector.isRepeating) {
            DecimalUtil.subtractChecked(0, vector[0], this.value, outputColumnVector);
            outputIsNull[0] = inputIsNull[0];
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = selected[j];
                    DecimalUtil.subtractChecked(i, vector[i], this.value, outputColumnVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.subtractChecked(i, vector[i], this.value, outputColumnVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = selected[j];
                DecimalUtil.subtractChecked(i, vector[i], this.value, outputColumnVector);
                outputIsNull[i] = inputIsNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.subtractChecked(i, vector[i], this.value, outputColumnVector);
            }
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public String getOutputType() {
        return "<ReturnType>";
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
        trace.attribute("dataType", this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = new BigDecimal(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
        super.capture(env, inputNode);
    }
}

