/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.StringColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import org.dom4j.Element;

public class XVectorFilterStringColumnBetween
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_LEFTVALUE = "leftValue";
    private static final String ATTRIBUTE_RIGHTVALUE = "rightValue";
    private int columnNo;
    private String leftValue;
    private String rightValue;

    public XVectorFilterStringColumnBetween(int theColumnNo, String theLeftValue, String theRightValue) {
        this.columnNo = theColumnNo;
        this.leftValue = theLeftValue;
        this.rightValue = theRightValue;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        Collator collator = context.getLocalCollator();
        int[] selected = batch.selected;
        StringColumnVector columns = (StringColumnVector)batch.columns[this.columnNo];
        boolean[] isNull = columns.isNull;
        String[] vector = columns.vector;
        if (columns.noNulls) {
            if (columns.isRepeating) {
                if (collator.compare(vector[0], this.leftValue) >= 0 && collator.compare(vector[0], this.rightValue) <= 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    if (collator.compare(vector[i], this.leftValue) < 0 || collator.compare(vector[i], this.rightValue) > 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            } else {
                int newSize = 0;
                for (int i = 0; i < n; ++i) {
                    if (collator.compare(vector[i], this.leftValue) < 0 || collator.compare(vector[i], this.rightValue) > 0) continue;
                    selected[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (columns.isRepeating) {
            if (!isNull[0]) {
                if (collator.compare(vector[0], this.leftValue) >= 0 && collator.compare(vector[0], this.rightValue) <= 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (isNull[i] || collator.compare(vector[i], this.leftValue) < 0 || collator.compare(vector[i], this.rightValue) > 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        } else {
            int newSize = 0;
            for (int i = 0; i < n; ++i) {
                if (isNull[i] || collator.compare(vector[i], this.leftValue) < 0 || collator.compare(vector[i], this.rightValue) > 0) continue;
                selected[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_COLUMNNO, this.columnNo);
        trace.attribute(ATTRIBUTE_LEFTVALUE, this.leftValue);
        trace.attribute(ATTRIBUTE_RIGHTVALUE, this.rightValue);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue(ATTRIBUTE_COLUMNNO));
        this.leftValue = inputNode.attributeValue(ATTRIBUTE_LEFTVALUE);
        this.rightValue = inputNode.attributeValue(ATTRIBUTE_RIGHTVALUE);
        super.capture(env, inputNode);
    }
}

