/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.vectorization.expressions.generated;

import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.vectorization.LongColumnVector;
import com.cognos.xqe.runtree.relational.vectorization.XVectorExpression;
import com.cognos.xqe.runtree.relational.vectorization.XVectorRowBatch;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Element;

public class XVectorLongColumnGreaterThanLongScalar
extends XVectorExpression {
    private static final long serialVersionUID = 1L;
    private int columnNo;
    private long value;
    private int outputColumnNo;

    public XVectorLongColumnGreaterThanLongScalar() {
    }

    public XVectorLongColumnGreaterThanLongScalar(int inColumnNo, Number inValue, int inOutputColumnNo) {
        this.columnNo = inColumnNo;
        this.value = inValue.longValue();
        this.outputColumnNo = inOutputColumnNo;
    }

    @Override
    public void evaluate(XDataContext context, XVectorRowBatch batch) throws XQERuntimeException {
        super.evaluate(context, batch);
        int n = batch.size;
        if (n == 0) {
            return;
        }
        int[] selected = batch.selected;
        LongColumnVector inputColumnVector = (LongColumnVector)batch.columns[this.columnNo];
        LongColumnVector outputColumnVector = (LongColumnVector)batch.columns[this.outputColumnNo];
        boolean[] inputIsNull = inputColumnVector.isNull;
        long[] vector = inputColumnVector.vector;
        boolean[] outputIsNull = outputColumnVector.isNull;
        long[] outputVector = outputColumnVector.vector;
        outputColumnVector.isRepeating = inputColumnVector.isRepeating;
        if (inputColumnVector.isRepeating) {
            outputVector[0] = vector[0] > this.value ? 1L : 0L;
        } else if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = selected[j];
                    outputVector[i] = vector[i] > this.value ? 1L : 0L;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    outputVector[i] = vector[i] > this.value ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j < n; ++j) {
                int i = selected[j];
                if (!inputIsNull[i]) {
                    if (vector[i] > this.value) {
                        outputVector[i] = 1L;
                        continue;
                    }
                    outputVector[i] = 0L;
                    continue;
                }
                outputIsNull[i] = true;
            }
        } else {
            System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
            for (int i = 0; i < n; ++i) {
                if (inputIsNull[i]) continue;
                outputVector[i] = vector[i] > this.value ? 1L : 0L;
            }
        }
    }

    @Override
    public int getColumnNo() {
        return this.outputColumnNo;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute("columnNo", this.columnNo);
        trace.attribute("value", String.valueOf(this.value));
        trace.attribute("outputColumnNo", this.outputColumnNo);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.columnNo = Integer.valueOf(inputNode.attributeValue("columnNo"));
        this.value = Long.valueOf(inputNode.attributeValue("value"));
        this.outputColumnNo = Integer.valueOf(inputNode.attributeValue("outputColumnNo"));
        this.dataType = DataTypeFactory.getType(inputNode.attribute("dataType").getValue());
    }
}

